/*
 * JHPdf Free PDF Library : HPdf3DAnnotExData.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.pdfobject.HPdfExData;
import net.sf.jhpdf.pdfobject.HPdf3DMeasure;
import net.sf.jhpdf.pdfobject.HPdfXref;

/**
 * Class represents PDF ExData for 3D annotation.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdf3DAnnotExData extends HPdfExData {

    private static final Logger logger = LoggerFactory.getLogger(HPdf3DAnnotExData.class);
    
    protected HPdf3DAnnotExData(HPdfXref xref) {
        super();
        
        logger.trace("HPdf3DAnnotExData#ctor");
        
        // MEMO: This class is the only concrete subclass of HPdfExData.
        // Some codes may belong to HPdfExData's ctor.
        xref.add(this);
        
        this.addName("Type", "ExData");
        this.addName("Subtype", "3DM");
    }
    
    public void set3DMeasurement(HPdf3DMeasure measure) {
        this.add("M3DREF", measure);
    }
}
