/*
 * JHPdf Free PDF Library : HPdfXrefEntry.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.io.HPdfWriteStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Xref entry.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfXrefEntry {
    
    public enum HPdfEntryType {
        FREE_ENTRY('f'),
        IN_USE_ENTRY('n'),
        ;
        
        private char pdfRep;
        
        HPdfEntryType(char pdfRep) {
            this.pdfRep = pdfRep;
        }
        public char getPdfRep() {
            return this.pdfRep;
        }
    }

    /**
     * ctor. this is package-private.
     */
    HPdfXrefEntry() {
        super();
        setByteOffset(0);
        setGenNo(0);
        setPdfObject(null);
        setEntryType(HPdfEntryType.FREE_ENTRY);
    }
    
    private long byteOffset;
    
    public long getByteOffset() {
        return this.byteOffset;
    }
    
    private int genNo;

    public int getGenNo() {
        return genNo;
    }

    void setGenNo(int genNo) {
        this.genNo = genNo;
    }
    
    public void setByteOffset(long offset) {
        this.byteOffset = offset;
    }
    
    private HPdfEntryType entryType;
    
    public HPdfEntryType getEntryType() {
        return this.entryType;
    }
    
    public void setEntryType(HPdfEntryType t) {
        this.entryType = t;
    }
    
    private HPdfObject pdfObject;
    
    public HPdfObject getPdfObject() {
        return this.pdfObject;
    }
    
    public void setPdfObject(HPdfObject obj) {
        this.pdfObject = obj;
    }
    
}
