/*
 * JHPdf Free PDF Library : HPdfReal.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.io.HPdfWriteStream;

/**
 * Class represents real number in PDF.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfReal extends HPdfObject {
    
    private float val;
    
    /**
     * ctor. this is package-private.
     */
    HPdfReal(float val) {
        super();
        setValue(val);
    }
    
    public float getValue() {
        return this.val;
    }
    
    // package-private
    void setValue(float val) {
        this.val = val;
    }

    @Override
    protected void writeValue(HPdfWriteStream stream, HPdfEncrypt e) {
        stream.writeReal(this.getValue());
    }
}
