/*
 * JHPdf Free PDF Library : HPdfFont.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfConst;
import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.graphics.HPdfTextWidth;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef;

/**
 * Abstract class represents PDF Font.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public abstract class HPdfFont extends HPdfFilterableDict {
    // TODO only stub, needs methods definition.

    private static final Logger logger = LoggerFactory.getLogger(HPdfFont.class);
    
    public enum HPdfFontType {
        TYPE1,
        TRUETYPE,
        TYPE3,
        TYPE0_CID,
        TYPE0_TT,
        CID_TYPE0,
        CID_TYPE2,
        MMTYPE1,
    }
    
    public enum HPdfWritingMode {
        HORIZONTAL,
        VERTICAL,
    }
    
    protected HPdfFont() {
        super();
    }
    
    public abstract String getFontName();
    
    public abstract HPdfEncoder getEncoder();
    
    public abstract String getEncodingName();
    
    public abstract int getUnicodeWidth(char code);
    
    public abstract HPdfRect getBBox();
    
    public abstract int getAscent();
    
    public abstract int getDescent();
    
    public abstract int getXHeight();
    
    public abstract int getCapHeight();
    
    public abstract HPdfTextWidth textWidth(String text, int len);
    
    public abstract int measureText(String text, int len,
            float width, float fontSize, float charSpace, float wordSpace,
            boolean wordWrap, float[] realWidth);
}
