/*
 * JHPdf Free PDF Library : HPdfWriteStream.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.io;

import net.sf.jhpdf.encrypt.HPdfEncrypt;

/**
 * Stream for writing interface.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public interface HPdfWriteStream extends HPdfStream {

    /**
     * writes byte sequence with indicated size to stream.
     * @param buf values to be written
     * @param siz size of values
     */
    public void write(byte[] buf, int siz);
    
    /**
     * writes byte sequence with indicated size and offsets
     * to stream.
     * @param buf values to be written
     * @param bufOffset offset to beginning position to be written.
     * @param siz size of values
     */
    public void write(byte[] buf, int bufOffset, int siz);
    
    // MEMO: writeAsBytes is original method of Java version
    // for convinience to output Java String just like C.
    // it should be deleted if rarely used,
    // so marked deprecated for check later.
    @Deprecated
    public void writeAsBytes(String value);
    
    /**
     * writes a string to stream.<br>
     * <strong>This method is not I18N compliant.
     * in other words, this method always considers the argument as ISO-8859-1 compatible.</strong>
     * if you want to use other encodings,
     * use {@link #writeBinary(byte[], long, HPdfEncrypt)} with byte-encoded String.
     * @param value string to be written
     */
    public void writeStr(String value);
    
    /**
     * writes a integer number to stream as string.
     * @param value number to be written
     */
    public void writeInt(long value);
    
    /**
     * writes a integer number (treated as unsigned) to stream as string.
     * @param value number to be written
     */
    public void writeUInt(long value);
    
    /**
     * writes a real number to stream as string.<br>
     * write-format can be affected by the PDF specification.
     * @param value number to be written
     */
    public void writeReal(float value);
    
    /**
     * writes PDF name to stream with escaping.<br>
     * attention: PDF name is considered as ISO-8859-1 string.
     * @param value PDF name to be written
     */
    public void writeEscapeName(String value);
    
    /**
     * writes a char to stream.
     * 'char' means actually a lobyte of value.
     * @param value char to be written
     */
    public void writeChar(char value);
    
    /**
     * writes a char(treated as unsigned) to stream.
     * 'char' means actually a unsigned lobyte of value.
     * @param value char to be written
     */
    public void writeUChar(char value);
    
    /**
     * writes byte sequence as hex-format with indicated size.
     * @param value  values to be written
     * @param len length of values
     * @param e encryption worker object(null if not needed encryption)
     */
    public void writeBinary(byte[] value, long len, HPdfEncrypt e);
    
    /**
     * writes a string to stream with escaping.<br>
     * <strong>string must be compatible for ISO-8859-1 encoding.</strong>
     * @param text string to be written
     */
    public void writeEscapeText(String text);
    
    /**
     * writes a string to stream with escaping and limitation of length.<br>
     * <strong>string must be compatible for ISO-8859-1 encoding.</strong>
     * @param text string to be written
     * @param len length of string
     */
    public void writeEscapeText2(String text, int len);
}
