/*
 * JHPdf Free PDF Library : JHPdf.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.pdfobject.HPdfDocument;

/**
 * JHPdf controller class.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class JHPdf {

    private static final Logger logger = LoggerFactory.getLogger(JHPdf.class);

    private JHPdf() {
        // inhibits instantiation.
    }

    /**
     * returns Library version text.
     * @return Library version text
     */
    public static String getVersion() {
        return JHPdfVersion.getJHPdfVersionText();
    }

    /**
     * creates new HPdfDocument.
     * @return new HPdfDocument instance
     */
    public static HPdfDocument createDocument() {
        logger.trace("JHPdf.createDocument");
        // TODO: only for stub
        return new HPdfDocument();
    }
}
