/*
 * JHPdf Free PDF Library : HPdfErrorCode.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf;

/**
 * Class for define error codes.(corresponds libHaru's one.)
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfErrorCode {
    
    private HPdfErrorCode() {
        // inhibits instanciation.
    }
    
    // error codes difinition from hpdf_error.h
    // MEMO: may contain useless ones for Java.
    public static final int HPDF_ARRAY_COUNT_ERR                      = 0x1001;
    public static final int HPDF_ARRAY_ITEM_NOT_FOUND                 = 0x1002;
    public static final int HPDF_ARRAY_ITEM_UNEXPECTED_TYPE           = 0x1003;
    public static final int HPDF_BINARY_LENGTH_ERR                    = 0x1004;
    public static final int HPDF_CANNOT_GET_PALLET                    = 0x1005;
    public static final int HPDF_DICT_COUNT_ERR                       = 0x1007;
    public static final int HPDF_DICT_ITEM_NOT_FOUND                  = 0x1008;
    public static final int HPDF_DICT_ITEM_UNEXPECTED_TYPE            = 0x1009;
    public static final int HPDF_DICT_STREAM_LENGTH_NOT_FOUND         = 0x100A;
    public static final int HPDF_DOC_ENCRYPTDICT_NOT_FOUND            = 0x100B;
    public static final int HPDF_DOC_INVALID_OBJECT                   = 0x100C;
/*                                                0x100D */
    public static final int HPDF_DUPLICATE_REGISTRATION               = 0x100E;
    public static final int HPDF_EXCEED_JWW_CODE_NUM_LIMIT            = 0x100F;
/*                                                0x1010 */
    public static final int HPDF_ENCRYPT_INVALID_PASSWORD             = 0x1011;
/*                                                0x1012 */
    public static final int HPDF_ERR_UNKNOWN_CLASS                    = 0x1013;
    public static final int HPDF_EXCEED_GSTATE_LIMIT                  = 0x1014;
    public static final int HPDF_FAILD_TO_ALLOC_MEM                   = 0x1015;
    public static final int HPDF_FILE_IO_ERROR                        = 0x1016;
    public static final int HPDF_FILE_OPEN_ERROR                      = 0x1017;
/*                                                0x1018 */
    public static final int HPDF_FONT_EXISTS                          = 0x1019;
    public static final int HPDF_FONT_INVALID_WIDTHS_TABLE            = 0x101A;
    public static final int HPDF_INVALID_AFM_HEADER                   = 0x101B;
    public static final int HPDF_INVALID_ANNOTATION                   = 0x101C;
/*                                                0x101D */
    public static final int HPDF_INVALID_BIT_PER_COMPONENT            = 0x101E;
    public static final int HPDF_INVALID_CHAR_MATRICS_DATA            = 0x101F;
    public static final int HPDF_INVALID_COLOR_SPACE                  = 0x1020;
    public static final int HPDF_INVALID_COMPRESSION_MODE             = 0x1021;
    public static final int HPDF_INVALID_DATE_TIME                    = 0x1022;
    public static final int HPDF_INVALID_DESTINATION                  = 0x1023;
/*                                                0x1024 */
    public static final int HPDF_INVALID_DOCUMENT                     = 0x1025;
    public static final int HPDF_INVALID_DOCUMENT_STATE               = 0x1026;
    public static final int HPDF_INVALID_ENCODER                      = 0x1027;
    public static final int HPDF_INVALID_ENCODER_TYPE                 = 0x1028;
/*                                                0x1029 */
/*                                                0x102A */
    public static final int HPDF_INVALID_ENCODING_NAME                = 0x102B;
    public static final int HPDF_INVALID_ENCRYPT_KEY_LEN              = 0x102C;
    public static final int HPDF_INVALID_FONTDEF_DATA                 = 0x102D;
    public static final int HPDF_INVALID_FONTDEF_TYPE                 = 0x102E;
    public static final int HPDF_INVALID_FONT_NAME                    = 0x102F;
    public static final int HPDF_INVALID_IMAGE                        = 0x1030;
    public static final int HPDF_INVALID_JPEG_DATA                    = 0x1031;
    public static final int HPDF_INVALID_N_DATA                       = 0x1032;
    public static final int HPDF_INVALID_OBJECT                       = 0x1033;
    public static final int HPDF_INVALID_OBJ_ID                       = 0x1034;
    public static final int HPDF_INVALID_OPERATION                    = 0x1035;
    public static final int HPDF_INVALID_OUTLINE                      = 0x1036;
    public static final int HPDF_INVALID_PAGE                         = 0x1037;
    public static final int HPDF_INVALID_PAGES                        = 0x1038;
    public static final int HPDF_INVALID_PARAMETER                    = 0x1039;
/*                                                0x103A */
    public static final int HPDF_INVALID_PNG_IMAGE                    = 0x103B;
    public static final int HPDF_INVALID_STREAM                       = 0x103C;
    public static final int HPDF_MISSING_FILE_NAME_ENTRY              = 0x103D;
/*                                                0x103E */
    public static final int HPDF_INVALID_TTC_FILE                     = 0x103F;
    public static final int HPDF_INVALID_TTC_INDEX                    = 0x1040;
    public static final int HPDF_INVALID_WX_DATA                      = 0x1041;
    public static final int HPDF_ITEM_NOT_FOUND                       = 0x1042;
    public static final int HPDF_LIBPNG_ERROR                         = 0x1043;
    public static final int HPDF_NAME_INVALID_VALUE                   = 0x1044;
    public static final int HPDF_NAME_OUT_OF_RANGE                    = 0x1045;
/*                                                0x1046 */
/*                                                0x1047 */
    public static final int HPDF_PAGE_INVALID_PARAM_COUNT             = 0x1048;
    public static final int HPDF_PAGES_MISSING_KIDS_ENTRY             = 0x1049;
    public static final int HPDF_PAGE_CANNOT_FIND_OBJECT              = 0x104A;
    public static final int HPDF_PAGE_CANNOT_GET_ROOT_PAGES           = 0x104B;
    public static final int HPDF_PAGE_CANNOT_RESTORE_GSTATE           = 0x104C;
    public static final int HPDF_PAGE_CANNOT_SET_PARENT               = 0x104D;
    public static final int HPDF_PAGE_FONT_NOT_FOUND                  = 0x104E;
    public static final int HPDF_PAGE_INVALID_FONT                    = 0x104F;
    public static final int HPDF_PAGE_INVALID_FONT_SIZE               = 0x1050;
    public static final int HPDF_PAGE_INVALID_GMODE                   = 0x1051;
    public static final int HPDF_PAGE_INVALID_INDEX                   = 0x1052;
    public static final int HPDF_PAGE_INVALID_ROTATE_VALUE            = 0x1053;
    public static final int HPDF_PAGE_INVALID_SIZE                    = 0x1054;
    public static final int HPDF_PAGE_INVALID_XOBJECT                 = 0x1055;
    public static final int HPDF_PAGE_OUT_OF_RANGE                    = 0x1056;
    public static final int HPDF_REAL_OUT_OF_RANGE                    = 0x1057;
    public static final int HPDF_STREAM_EOF                           = 0x1058;
    public static final int HPDF_STREAM_READLN_CONTINUE               = 0x1059;
/*                                                0x105A */
    public static final int HPDF_STRING_OUT_OF_RANGE                  = 0x105B;
    public static final int HPDF_THIS_FUNC_WAS_SKIPPED                = 0x105C;
    public static final int HPDF_TTF_CANNOT_EMBEDDING_FONT            = 0x105D;
    public static final int HPDF_TTF_INVALID_CMAP                     = 0x105E;
    public static final int HPDF_TTF_INVALID_FOMAT                    = 0x105F;
    public static final int HPDF_TTF_MISSING_TABLE                    = 0x1060;
    public static final int HPDF_UNSUPPORTED_FONT_TYPE                = 0x1061;
    public static final int HPDF_UNSUPPORTED_FUNC                     = 0x1062;
    public static final int HPDF_UNSUPPORTED_JPEG_FORMAT              = 0x1063;
    public static final int HPDF_UNSUPPORTED_TYPE1_FONT               = 0x1064;
    public static final int HPDF_XREF_COUNT_ERR                       = 0x1065;
    public static final int HPDF_ZLIB_ERROR                           = 0x1066;
    public static final int HPDF_INVALID_PAGE_INDEX                   = 0x1067;
    public static final int HPDF_INVALID_URI                          = 0x1068;
    public static final int HPDF_PAGE_LAYOUT_OUT_OF_RANGE             = 0x1069;
    public static final int HPDF_PAGE_MODE_OUT_OF_RANGE               = 0x1070;
    public static final int HPDF_PAGE_NUM_STYLE_OUT_OF_RANGE          = 0x1071;
    public static final int HPDF_ANNOT_INVALID_ICON                   = 0x1072;
    public static final int HPDF_ANNOT_INVALID_BORDER_STYLE           = 0x1073;
    public static final int HPDF_PAGE_INVALID_DIRECTION               = 0x1074;
    public static final int HPDF_INVALID_FONT                         = 0x1075;
    public static final int HPDF_PAGE_INSUFFICIENT_SPACE              = 0x1076;
    public static final int HPDF_PAGE_INVALID_DISPLAY_TIME            = 0x1077;
    public static final int HPDF_PAGE_INVALID_TRANSITION_TIME         = 0x1078;
    public static final int HPDF_INVALID_PAGE_SLIDESHOW_TYPE          = 0x1079;
    public static final int HPDF_EXT_GSTATE_OUT_OF_RANGE              = 0x1080;
    public static final int HPDF_INVALID_EXT_GSTATE                   = 0x1081;
    public static final int HPDF_EXT_GSTATE_READ_ONLY                 = 0x1082;
    public static final int HPDF_INVALID_U3D_DATA                     = 0x1083;
    public static final int HPDF_NAME_CANNOT_GET_NAMES                = 0x1084;
    public static final int HPDF_INVALID_ICC_COMPONENT_NUM            = 0x1085;
}
