/*
 * JHPdf Free PDF Library : TTFontDemoJp.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/character_map.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import java.io.*;

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfDocument.HPdfCompressionMode;


public class TTFontDemoJp implements DemoEntry {
    public static void main(String[] args) {
        new TTFontDemoJp().demo(args);
    }
    
    private static final String F_NAME = "TTFontDemoJp.pdf";
    
    private String getSample() throws IOException {
        String s = null;
        BufferedReader f = null;
        String filePath = "mbtext" + File.separator + "sjis.txt";
        try {
            // Generally 'SJIS' means 'ms932'(windows-31j) actually.
            f = new BufferedReader(
                new InputStreamReader(new FileInputStream(filePath), "ms932"));
            s = f.readLine();
        } catch (IOException ioe) {
            System.out.println("error: cannot open 'mbtext/sjis.txt'");
            throw ioe;
        } finally {
            if (f != null) {
                try {
                    f.close();
                    f = null;
                } catch (Exception e) {
                    // nop
                }
            }
        }
        return s;
    }
    
    @Override
    public void demo(String[] args) {
        
        if (args.length < 2) {
            System.out.println("java TTFontDemoJp <ttf-font-filename> [-E]");
            System.out.println("java TTFontDemoJp <ttc-font-filename> <index> [-E]");
            return;
        }
        
        HPdfDocument pdf = null;
        try {
            String SAMP_TXT = getSample();
            
            pdf = JHPdf.createDocument();
            
            /* declaration for using Japanese encoding. */
            pdf.useJPEncodings();
            
            pdf.setCompressionMode(HPdfCompressionMode.ALL);
            
            /* load ttc file */
            String detailFontName;
            if (args.length == 3 && args[2].equals("-E")) {
                detailFontName = pdf.loadTTFontFromFile2(args[0],
                    Integer.parseInt(args[1]), true);
            } else if (args.length == 2 && args[1].equals("-E")) {
                detailFontName = pdf.loadTTFontFromFile(args[0], true);
            } else if (args.length == 2) {
                detailFontName = pdf.loadTTFontFromFile2(args[0],
                    Integer.parseInt(args[1]), false);
            } else {
                detailFontName = pdf.loadTTFontFromFile(args[0], false);
            }
            
            /* Add a new page object. */
            HPdfPage page = pdf.addPage();
            
            HPdfFont titleFont = pdf.getFont("Helvetica", null);
            
            HPdfFont detailFont = pdf.getFont(detailFontName, "90msp-RKSJ-H");
            
            page.setFontAndSize(titleFont, 10);
            
            page.beginText();
            
            /* Move the position of the text to top of the page. */
            page.moveTextPos(10, 190);
            page.showText(detailFontName);
            page.showText("(");
            page.showText(detailFont.getEncodingName());
            page.showText(")");
            
            page.setFontAndSize(detailFont, 15);
            page.moveTextPos(10, -20);
            page.showText("abcdefghijklmnopqrstuvwxyz");
            page.moveTextPos(0, -20);
            page.showText("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
            page.moveTextPos(0, -20);
            page.showText("1234567890");
            page.moveTextPos(0, -20);

            page.setFontAndSize(detailFont, 10);
            page.showText(SAMP_TXT);
            page.moveTextPos(0, -18);

            page.setFontAndSize(detailFont, 16);
            page.showText(SAMP_TXT);
            page.moveTextPos(0, -27);

            page.setFontAndSize(detailFont, 23);
            page.showText(SAMP_TXT);
            page.moveTextPos(0, -36);

            page.setFontAndSize(detailFont, 30);
            page.showText(SAMP_TXT);
            page.moveTextPos(0, -36);

            float pw = page.textWidth(SAMP_TXT);
            float page_height = 210;
            float page_width = pw + 40;

            page.setWidth(page_width);
            page.setHeight(page_height);

            /* Finish to print text. */
            page.endText();

            page.setLineWidth(0.5F);

            page.moveTo(10, page_height - 25);
            page.lineTo(page_width - 10, page_height - 25);
            page.stroke();

            page.moveTo(10, page_height - 85);
            page.lineTo(page_width - 10, page_height - 85);
            page.stroke();
            
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
}
