/*
 * JHPdf Free PDF Library : JpFontDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/arc_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import java.io.*;

import net.sf.jhpdf.*;
import net.sf.jhpdf.graphics.HPdfPoint;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfDocument.HPdfCompressionMode;
import net.sf.jhpdf.pdfobject.HPdfCatalog.HPdfPageMode;


public class JpFontDemo implements DemoEntry {
    public static void main(String[] args) {
        new JpFontDemo().demo(args);
    }
    
    private static final String F_NAME = "JpFontDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        
        final int PAGE_HEIGHT = 210;
        
        BufferedReader f = null;
        
        HPdfDocument pdf = null;
        try {
            try {
                f = createReader("mbtext" + File.separator + "sjis.txt", "ms932"); // Generally 'SJIS' means 'ms932'(windows-31j) actually.
            } catch (IOException ioe) {
                System.out.println("error: cannot open 'mbtext/sjis.txt'");
                throw ioe;
            }
            
            String sampText = f.readLine();
            f.close();
            f = null; // MEMO: avoid double-close
            
            pdf = JHPdf.createDocument();
            
            pdf.setCompressionMode(HPdfCompressionMode.ALL);
            pdf.useJPEncodings();
            pdf.useJPFonts();
            
            HPdfFont[] detailFont = new HPdfFont[16];
            
            detailFont[0] = pdf.getFont("MS-Mincyo", "90ms-RKSJ-H");
            detailFont[1] = pdf.getFont("MS-Mincyo,Bold", "90ms-RKSJ-H");
            detailFont[2] = pdf.getFont("MS-Mincyo,Italic", "90ms-RKSJ-H");
            detailFont[3] = pdf.getFont("MS-Mincyo,BoldItalic", "90ms-RKSJ-H");
            detailFont[4] = pdf.getFont("MS-PMincyo", "90msp-RKSJ-H");
            detailFont[5] = pdf.getFont("MS-PMincyo,Bold", "90msp-RKSJ-H");
            detailFont[6] = pdf.getFont("MS-PMincyo,Italic", "90msp-RKSJ-H");
            detailFont[7] = pdf.getFont("MS-PMincyo,BoldItalic",
                    "90msp-RKSJ-H");
            detailFont[8] = pdf.getFont("MS-Gothic", "90ms-RKSJ-H");
            detailFont[9] = pdf.getFont("MS-Gothic,Bold", "90ms-RKSJ-H");
            detailFont[10] = pdf.getFont("MS-Gothic,Italic", "90ms-RKSJ-H");
            detailFont[11] = pdf.getFont("MS-Gothic,BoldItalic", "90ms-RKSJ-H");
            detailFont[12] = pdf.getFont("MS-PGothic", "90msp-RKSJ-H");
            detailFont[13] = pdf.getFont("MS-PGothic,Bold", "90msp-RKSJ-H");
            detailFont[14] = pdf.getFont("MS-PGothic,Italic", "90msp-RKSJ-H");
            detailFont[15] = pdf.getFont("MS-PGothic,BoldItalic",
                    "90msp-RKSJ-H");
            
            /* Set page mode to use outlines. */
            pdf.setPageMode(HPdfPageMode.USE_OUTLINE);
            
            /* create outline root. */
            HPdfOutline root = pdf.createOutline(null, "JP font demo", null);
            root.setOpened(true);
            
            for (final HPdfFont font : detailFont) {
                /* add a new page object. */
                HPdfPage page = pdf.addPage();
                
                /* create outline entry */
                HPdfOutline outline = pdf.createOutline(root,
                    font.getFontName(), null);
                HPdfDestination dst = page.createDestination();
                outline.setDestination(dst);
                
                HPdfFont titleFont = pdf.getFont("Helvetica", null);
                page.setFontAndSize(titleFont, 10);
                
                page.beginText();
                
                /* move the position of the text to top of the page. */
                page.moveTextPos(10, 190);
                page.showText(font.getFontName());

                page.setFontAndSize(font, 15);
                page.moveTextPos(10, -20);
                page.showText("abcdefghijklmnopqrstuvwxyz");
                page.moveTextPos(0, -20);
                page.showText("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
                page.moveTextPos(0, -20);
                page.showText("1234567890");
                page.moveTextPos(0, -20);

                page.setFontAndSize(font, 10);
                page.showText(sampText);
                page.moveTextPos(0, -18);

                page.setFontAndSize(font, 16);
                page.showText(sampText);
                page.moveTextPos(0, -27);

                page.setFontAndSize(font, 23);
                page.showText(sampText);
                page.moveTextPos(0, -36);

                page.setFontAndSize(font, 30);
                page.showText(sampText);
                
                HPdfPoint p = page.getCurrentTextPos();
                
                /* finish to print text. */
                page.endText();
                
                page.setLineWidth(0.5F);
                
                float xPos = 20;
                
                for (int j = 0; j < sampText.length() / 2; ++j) {
                    page.moveTo(xPos, p.getY() - 10);
                    page.lineTo(xPos, p.getY() - 12);
                    page.stroke();
                    xPos += 30;
                }
                
                page.setWidth(p.getX() + 20);
                page.setHeight(PAGE_HEIGHT);

                page.moveTo(10, PAGE_HEIGHT - 25);
                page.lineTo(p.getX() + 10, PAGE_HEIGHT - 25);
                page.stroke();

                page.moveTo(10, PAGE_HEIGHT - 85);
                page.lineTo(p.getX() + 10, PAGE_HEIGHT - 85);
                page.stroke();

                page.moveTo(10, p.getY() - 12);
                page.lineTo(p.getX() + 10, p.getY() - 12);
                page.stroke();
            }
            
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
            try {
                if (f != null) {
                    f.close();
                    f = null;
                }
            } catch (IOException ee) {
                // NOP
            }
        }
    }
    
    private BufferedReader createReader(String filePath, String charsetName) throws IOException {
        return new BufferedReader(
            new InputStreamReader(new FileInputStream(filePath), charsetName));
    }
}
