/*
 * JHPdf Free PDF Library : ImageDemo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/line_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import java.io.File;

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfDocument.HPdfCompressionMode;


public class ImageDemo implements DemoEntry {
    public static void main(String[] args) {
        new ImageDemo().demo(args);
    }
    
    private static final String F_NAME = "ImageDemo.pdf";
    
    @Override
    public void demo(String[] args) {
        
        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            pdf.setCompressionMode(HPdfCompressionMode.ALL);
            
            /* create default-font */
            HPdfFont font = pdf.getFont("Helvetica", null);
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();
            
            page.setWidth(550);
            page.setHeight(500);
            
            HPdfDestination dst = page.createDestination();
            dst.setXYZ(0, page.getHeight(), 1);
            pdf.setOpenAction(dst);
            
            page.beginText();
            page.setFontAndSize(font, 20);
            page.moveTextPos(220, page.getHeight() - 70);
            page.showText("ImageDemo");
            page.endText();
            
            /* load image file. */
            HPdfImage image = pdf.loadPngImageFromFile("pngsuite" + File.separator + "basn3p02.png");
            
            /* image1 is masked by image2. */
            HPdfImage image1 = pdf.loadPngImageFromFile("pngsuite" + File.separator + "basn3p02.png");
            
            /* image2 is a mask image. */
            HPdfImage image2 = pdf.loadPngImageFromFile("pngsuite" + File.separator + "basn0g01.png");
            
            /* image3 is a RGB-color image. we use this image for color-mask
             * demo.
             */
            HPdfImage image3 = pdf.loadPngImageFromFile("pngsuite" + File.separator + "maskimage.png");
            
            float iw = image.getWidth();
            float ih = image.getHeight();
            
            page.setLineWidth(0.5F);
            
            float x = 100;
            float y = page.getHeight() - 150;
            
            /* Draw image to the canvas. (normal-mode with actual size.)*/
            page.drawImage(image, x, y, iw, ih);
            
            showDescription(page, x, y, "Actual Size");
            
            x += 150;
            
            /* Scalling image (X direction) */
            page.drawImage(image, x, y, iw * 1.5F, ih);
            
            showDescription(page, x, y, "Scalling image (X direction)");
            
            x += 150;
            
            /* Scalling image (Y direction). */
            page.drawImage(image, x, y, iw, ih * 1.5F);
            
            showDescription(page, x, y, "Scalling image (Y direction)");
            
            x = 100;
            y -= 120;
            
            /* Skewing image. */
            float angle1 = 10;
            float angle2 = 20;
            float rad1 = angle1 / 180 * 3.141592F; // MEMO: Literal 'PI' is written in original code.
            float rad2 = angle2 / 180 * 3.141592F;
            
            page.gSave();
            
            page.concat(iw, (float) (Math.tan(rad1) * iw), (float) (Math.tan(rad2) * ih), ih, x, y);
            
            page.executeXObject(image);
            page.gRestore();
            
            showDescription(page, x, y, "Skewing image");
            
            x += 150;
            
            /* Rotating image */
            float angle = 30;     /* rotation of 30 degrees. */
            float rad = (float) (angle / 180 * 3.141592); /* Calcurate the radian value. */
            
            page.gSave();
            page.concat((float) (iw * Math.cos(rad)),
                (float) (iw * Math.sin(rad)),
                (float) (ih * -Math.sin(rad)),
                (float) (ih * Math.cos(rad)),
                x, y);
            
            page.executeXObject(image);
            page.gRestore();
            
            showDescription(page, x, y, "Rotating image");
            
                x += 150;
            
            /* draw masked image. */
            
            /* Set image2 to the mask image of image1 */
            image1.setMaskImage(image2);
            
            page.setRGBFill(0, 0, 0);
            page.beginText();
            page.moveTextPos(x - 6, y + 14);
            page.showText("MASKMASK");
            page.endText();
            
            page.drawImage(image1, x - 3, y - 3, iw + 6, ih + 6);
            
            showDescription(page, x, y, "masked image");
            
                x = 100;
                y -= 120;
            
            /* color mask. */
            page.setRGBFill(0, 0, 0);
            page.beginText();
            page.moveTextPos(x - 6, y + 14);
            page.showText("MASKMASK");
            page.endText();
            
            image3.setColorMask(0, 255, 0, 0, 0, 255);
            page.drawImage(image3, x, y, iw, ih);
            
            showDescription(page, x, y, "Color Mask");
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    private void showDescription(HPdfPage page, float x, float y, String text) {
        
        page.moveTo(x, y - 10);
        page.lineTo(x, y + 10);
        page.moveTo(x - 10, y);
        page.lineTo(x + 10, y);
        page.stroke();
        
        page.setFontAndSize(page.getCurrentFont(), 8);
        page.setRGBFill(0, 0, 0);
        
        String buf = String.format("(x=%d,y=%d)", (int)x, (int)y);
        page.beginText();
        page.moveTextPos(x - page.textWidth(buf) - 5, y - 10);
        page.showText(buf);
        page.endText();
        
        page.beginText();
        page.moveTextPos(x - 20, y - 25);
        page.showText(text);
        page.endText();
    }
    
}
