﻿Imports vbGofSample.State.Framework

Namespace GUI

    Public Class StateForm
        Implements IContext


        Private _state As IState = DayState.GetInstance
        Private _now As Integer = 0


        ' フォームロード時の処理を行います。
        Private Sub SafeForm_Load(ByVal sender As System.Object, _
                                  ByVal e As System.EventArgs) Handles MyBase.Load
            _clockTimer.Enabled = True
        End Sub

        ' フォームクローズ時の処理を行います。
        Private Sub SafeForm_Closed(ByVal sender As Object, _
                                    ByVal e As System.EventArgs) Handles MyBase.Closed
            _clockTimer.Enabled = False
        End Sub

        ' タイマーイベント時の処理を行います。
        Private Sub ClockTimer_Tick(ByVal sender As System.Object, _
                                    ByVal e As System.EventArgs) Handles _clockTimer.Tick
            If (_now >= 23) Then _now = 0

            SetClock(_now)

            _now += 1
        End Sub

        Private Sub _useButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _useButton.Click
            _state.DoUse(Me)
        End Sub

        Private Sub _alarmButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _alarmButton.Click
            _state.DoAlarm(Me)
        End Sub

        Private Sub _phoneButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _phoneButton.Click
            _state.DoPhone(Me)
        End Sub

        Private Sub _exitButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _exitButton.Click
            Close()
        End Sub

        ' 時刻を設定します。
        Public Sub SetClock(ByVal hour As Integer) Implements IContext.SetClock
            Dim clockString As String = "現在時刻は"

            If (hour < 10) Then
                clockString &= String.Format("0{0}:00", hour)
            Else
                clockString &= String.Format("{0}:00", hour)
            End If

            Console.WriteLine(clockString)
            _clockTextBox.Text = clockString

            _state.DoClock(Me, hour)
        End Sub

        ' 状態を変化させます。
        Public Sub ChageState(ByVal state As IState) Implements IContext.ChageState
            Console.Write(_state)
            Console.Write("から")
            Console.Write(state)
            Console.Write("へ状態が変化しました。")
            Console.WriteLine()

            _state = state
        End Sub

        ' 警備センターを呼び出します。
        Public Sub CallSecurityCenter(ByVal message As String) Implements IContext.CallSecurityCenter
            _screenTextBox.AppendText(String.Format("call ! {0}", message) & vbCrLf)
        End Sub

        ' 警備センターの記録です。
        Public Sub RecordLog(ByVal message As String) Implements IContext.RecordLog
            _screenTextBox.AppendText(String.Format("record ... {0}", message) & vbCrLf)
        End Sub




    End Class

End Namespace

