﻿Namespace Framework


    Public Class DayState
        Implements IState

        Private Shared _singleton As DayState = New DayState()

        ' コンストラクタです。(外部からのアクセス不可)
        Private Sub New()

        End Sub

        ' 唯一のインスタンスを取得します。
        Public Shared Function GetInstance() As IState
            Return _singleton
        End Function

        ' 時刻を設定します。
        Public Sub DoClock(ByVal context As IContext, ByVal hour As Integer) Implements IState.DoClock
            If (hour < 9 OrElse 17 <= hour) Then
                context.ChageState(NightState.GetInstance)
            End If
        End Sub

        ' 金庫を使用します。
        Public Sub DoUse(ByVal context As IContext) Implements IState.DoUse
            context.RecordLog("金庫使用(昼間)")
        End Sub

        ' 非常ベルを鳴らします。
        Public Sub DoAlarm(ByVal context As IContext) Implements IState.DoAlarm
            context.CallSecurityCenter("非常ベル(昼間)")
        End Sub

        ' 通常の通話を行います。
        Public Sub DoPhone(ByVal context As IContext) Implements IState.DoPhone
            context.CallSecurityCenter("通常の通話(昼間)")
        End Sub

        ' DayStateの文字列表現を返します。
        Public Overrides Function ToString() As String
            Return "[昼間]"
        End Function

    End Class

End Namespace