Point = {}

function Point:new()
	local t = {}
	t.x = 0
	t.y = 0
	setmetatable(t, { __index = Point })
	return t
end

function Point:set(dx, dy)
	self.x = dx
	self.y = dy
end

function Point:offset(pt)
	self.x = self.x + pt.x
	self.y = self.x + pt.y
end

function Point:to_string()
	return string.format("point x:%d, y:%d", self.x, self.y)
end

-- PointNX̗p
local pt1 = Point:new()
local pt2 = Point:new()


pt1:set(10, 20)
pt2:set(5, 5)

pt1:offset(pt2)

print(pt1:to_string())