#ifndef __LUA_HELPER_H__
#define __LUA_HELPER_H__

extern "C" {
#include "lua.h"
#include "lualib.h"
#include "lauxlib.h"
}

// p[^̂P̒li[NX
class LuaFuncParamItem
{
public:
	unsigned int m_type; //p[^^CvFLUA_TNIL/LUA_TNUMBER/LUA_TSTRING/LUA_TBOOLEAN
	union {
		double m_number; // l̏ꍇ̒l
		char *m_str; // ̏ꍇ̒l
		bool m_bool; // u[̏ꍇ̒l
	};

public:
	LuaFuncParamItem() : m_type(LUA_TNIL), m_number(0) {}
	~LuaFuncParamItem() { ReleaseValue(); }

	// ^擾֐
	unsigned int GetType() const { return m_type; }

	// ^`FbN֐
	bool IsNil()    const { return m_type == LUA_TNIL; }
	bool IsNumber() const { return m_type == LUA_TNUMBER; }
	bool IsString() const { return m_type == LUA_TSTRING; }
	bool IsBool()   const { return m_type == LUA_TBOOLEAN; }

	// l擾֐
	double GetNumber()        const { return m_number; }
	const char * GetString()  const { return m_str; }
	bool GetBool()            const { return m_bool; }

	// obt@
	void ReleaseValue();

	// lZbg
	void SetNumber(double number);
	// lZbg
	void SetString(const char * str);
	// nillZbg
	void SetNil();
	// boollZbg
	void SetBool(bool value);

	// i[ĂlLuaX^bNɐς
	void PushToStack(lua_State *L);
};

// [U[璼ڎg֐p[^NX
// LuaFuncParam param;
// param.Number(10).String("hello").Nil().Number(50);
// ̂悤ɎgB
class LuaFuncParam
{
private:
	enum {
		PARAMS_MAX = 20, // őp[^
	};
	LuaFuncParamItem m_params[PARAMS_MAX];
	int m_params_count;

public:
	LuaFuncParam() : m_params_count(0) {}
	~LuaFuncParam() { Clear(); }

	// p[^SNA
	void Clear();
	// p[^Ԃ
	int GetCount() { return m_params_count; }

	// ep[^̒ǉ
	LuaFuncParam & Number(double number);
	LuaFuncParam & String(const char *str);
	LuaFuncParam & Nil();
	LuaFuncParam & Bool(bool value);

	// wCfbNX̃p[^l擾
	// (CfbNX͂Ox[Xj
	bool IsNil(int index);
	double GetNumber(int index);
	const char * GetString(int index);
	const bool GetBool(int index);

	// LuaX^bNɈvbVāAvbV̐Ԃ
	int PushToStack(lua_State *L);
	// LuaX^bNl擾
	// X^bNgbvresult_count̒l擾Ċi[
	void GetFromStack(lua_State *L, int result_count);
};

// Luag₷邽߂̃NX
class LuaHelper
{
private:
	lua_State *m_L;		// LuaXe[g
	char m_err[1000];	// G[
	lua_CFunction m_pGetStackTraceFunc;	// debug.traceback̎ւ̃|C^

public:
	LuaHelper() : m_L(NULL), m_pGetStackTraceFunc(NULL) {}
	~LuaHelper() { Close(); }

	// LuaXe[g
	void Close();

	// LuaXe[gZbg
	// ɁAdebug.traceback̎ւ̃|C^𓾂
	// î߁ALuaCuI[vオ]܂j
	void SetLua(lua_State *L) ;
	// LuaXe[g̎擾
	lua_State *GetLua() { return m_L; }

	// print֐ݒ
	void InitPrintFunc();

#ifdef _WIN32
	// print֐FVC++̃bZ[WƂďo
	static int LuaPrintWindows(lua_State *L);
#endif

	// OCallFuncɂẴG[bZ[W擾
	const char * GetErr() { return m_err; }
	// ֐R[
	// result,paramsNULLłǂ
	bool CallFunc(const char *funcname, LuaFuncParam* result = NULL, int result_count = 0, LuaFuncParam* params = NULL);
	// t@Cs
	// result,paramsNULLłǂ
	bool DoFile(const char *path, LuaFuncParam* result = NULL, int result_count = 0, LuaFuncParam* params = NULL);

protected:
	// G[bZ[WZbg
	void SetErr(const char *location, const char *message);
	// ^[lƃX^bN̒lG[bZ[Wݒ
	void AnalyzeError(int res_call, const char *location);
	// pcallуX^bN܂̏sTu[`
	int CallSub(LuaFuncParam* result, int result_count, LuaFuncParam* params, int errfunc_index);
};

#endif //__LUA_HELPER_H__
