// luasample1.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "time.h"
#include <lua.hpp>
#include "tolua++.h"
#include "tolua_glue/shop_glue.h"

static void PrintStackItem(lua_State *L, int idx)
{
	int type = lua_type(L, idx);
	switch(type) {
	case LUA_TSTRING:
		printf("index %2d : type = %s : \"%s\"\n",
			idx, lua_typename(L, type), lua_tostring(L, idx));
		break;
	case LUA_TNUMBER:
		printf("index %2d : type = %s : %f\n",
			idx, lua_typename(L, type), lua_tonumber(L, idx));
		break;
	case LUA_TBOOLEAN:
		printf("index %2d : type = %s : \"%s\"\n",
			idx, lua_typename(L, type),
			lua_toboolean(L, idx) ? "true" : "false");
		break;
	default:
		printf("index %2d : type= %s\n", idx, lua_typename(L, type));
		break;
	}
}

void PrintStack(lua_State *L)
{
	printf("----- stack -----\n");
	int top = lua_gettop(L);
	for(int i = top; i >= 1; i--) {
		PrintStackItem(L,i);
	}
	printf("-----------------\n");
	
	for(int i = -1; i >= -top; i--) {
		PrintStackItem(L,i);
	}
	printf("-----------------\n");
}

int GetSelection(const char *title)
{
	char input[100];

	printf("%s >", title);
	fgets(input, sizeof(input), stdin);
	printf("\n");
	if(strlen(input) == 0 || !isdigit(input[0])) return -1;
	return atoi(input);
}

struct SItemInfo
{
	char name[100];
	int price;
};
typedef struct SItemInfo ItemInfo;

#define MAX_SHOP_ITEMS 5

ItemInfo shop_items[MAX_SHOP_ITEMS] = {
	{"", 100},
	{"ڂ", 1000},
	{"z̕", 2000},
	{"", -1},
	{"",-1},
};

int g_money = 0;

int GetMoney()
{
	return g_money;
}

void SetMoney(int money)
{
	g_money = money;
}

const char * GetItemName(int index)
{
	if(index < 0 || index >= MAX_SHOP_ITEMS) return NULL;
	return shop_items[index].name;
}

int GetItemPrice(int index)
{
	if(index < 0 || index >= MAX_SHOP_ITEMS) return -1;
	return shop_items[index].price;
}

bool AddItem(const char *name, int price){
	for(int i = 0; i< MAX_SHOP_ITEMS; i++) {
		if(shop_items[i].price == -1){
			strcpy(shop_items[i].name,name);
			shop_items[i].price = price;
			return true;
		}
	}
	return false;
}

void LoadScript(lua_State *L)
{
	while(true) {
		int top = lua_gettop(L);
		int ret = luaL_dofile(L, "douguya.lua");
		
		if(ret != 0){
			printf("error: %s\n", lua_tostring(L, -1));
			lua_settop(L, top);
			printf("<G^[L[ƃXNvgǂݒ܂B>\n");
			getchar();
		}
		else {
			lua_settop(L, top);
			break;
		}
	}
}

void DoShopScript(lua_State *L) {
	while(true) {
		lua_getglobal(L, "Shop");
		int ret = lua_pcall(L, 0, 0, NULL);
		if (ret != 0) {
			printf("error: %s\n", lua_tostring(L, -1));
			lua_pop(L, 1);
			printf("G^[L[ƃXNvgǂݒ܂\n");
			getchar();
			// XNvg[hȂ
			LoadScript(L);
			continue;
		}
		break;
	}
}
	 

int main(int argc, char* argv[])
{
	srand((unsigned int)time(NULL));
	for(int i = 0; i < 100; i++) rand();

	lua_State *L = lua_open();
	luaL_openlibs(L);

	tolua_shop_open(L);



	g_money = (rand() *  10000 / RAND_MAX) + 500;

	LoadScript(L);

	while(true) {
		DoShopScript(L);
		getchar();
	}

	
	lua_close(L);

	return 0;
}

