#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QDebug>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ThLCDOut = new ThLCDOutput(this);
    connect(ThLCDOut, SIGNAL(notify_dio_ready(int)),
            this, SLOT(slot_dio_ready(int)));
    ThLCDOut->start();

    ui->statusBar->showMessage("DIO & LCD initialize...");
}

MainWindow::~MainWindow()
{
    ThLCDOut->stop();
    ThLCDOut->wait();
    delete ThLCDOut;

    delete ui;
}

void MainWindow::slot_dio_ready(int status)
{
    if (status) {
        ui->statusBar->showMessage("Device Error!");
    } else {
        qDebug() << "DIO Ready.";
        ui->statusBar->showMessage("Idle...");
        ui->pushButton_Init->setEnabled(true);
        ui->pushButton_Clear->setEnabled(true);
        ui->pushButton_Enter->setEnabled(true);
    }
}

void MainWindow::on_pushButton_Init_clicked()
{
    ThLCDOut->sendEvent_Init();
}

void MainWindow::on_pushButton_Clear_clicked()
{
    ThLCDOut->sendEvent_Clear();
}

void MainWindow::on_pushButton_Enter_clicked()
{
    if (ui->lineEdit_LCDOutputText->text().isEmpty()) {
        ;
    } else {
        // enq command SetOutputText
        qDebug() << "Send Text is " << ui->lineEdit_LCDOutputText->text();
        ThLCDOut->sendEvent_OutputText(ui->lineEdit_LCDOutputText->text());
    }
}

