﻿#include "StdAfx.h"
#include "test_window.h"

#define BOOST_ASSIGN_MAX_PARAMS 7
#include <boost/assign.hpp>
#include <boost/assign/ptr_list_of.hpp>
#include <boost/assign/ptr_list_inserter.hpp>
#include <boost/foreach.hpp>

#if _DEBUG
#define _CRTDBG_MAP_ALLOC
#include <crtdbg.h>
#define new new(_NORMAL_BLOCK, __FILE__, __LINE__)
#endif

#include "sf_windows.h"
#include "toplevel_window.h"
#include "CommDlg.h"
#include "icon.h"
#include "timer.h"
#include "exception.h"
#include "application.h"



#define THROW_IFERR(hres) \
  if (FAILED(hres)) { throw sf::win32_error_exception(hres); }

#ifndef HINST_THISCOMPONENT
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
#define HINST_THISCOMPONENT ((HINSTANCE)&__ImageBase)
#endif

namespace sf 
{
  test_window::test_window(
    const std::wstring& title,
    const std::wstring& name,bool fit_to_display,
    float width,float height) : base_win32_window_t(title,name,fit_to_display,width,height),x_(0),y_(0),click_(false)

  {
    register_class();
    create();
//    update();
  }


  test_window::~test_window()
  {
  }

  void test_window::create()
  {
    create_window();
  }

  test_window::result_t test_window::on_left_mouse_button_down(uint32_t mouse_key,int x,int y ) 
  {
    click_ = true;
    RECT r;
    GetWindowRect(hwnd_,&r);
    POINT p={x,y};
    ClientToScreen(hwnd_,&p);
    x_ = p.x - r.left;
    y_ = p.y - r.top;
    return 0; 
  }



  test_window::result_t test_window::on_left_mouse_button_up(uint32_t mouse_key,int x,int y) 
  { 
    click_ = false;
    return 0; 
  }

  test_window::result_t test_window::on_mouse_move(uint32_t mouse_key,int x,int y)
  {
    if(click_){
      POINT p = {x,y};
      ClientToScreen(hwnd_,&p);
      SetWindowPos(hwnd_,NULL,p.x - x_,p.y - y_,0,0,SWP_NOOWNERZORDER | SWP_NOREDRAW | SWP_NOSIZE | SWP_NOZORDER);
    }
    return 0;
  }

 test_child_window::test_child_window(
    base_window& window,
    const std::wstring& title,
    const std::wstring& name,bool fit_to_display,
    float width,float height) : base_win32_window_t(title,name,fit_to_display,width,height),parent_window_(window)
 {
    register_class();
    create();
    ::MoveWindow(hwnd_,500,300,320,240,FALSE);
//    update();
  }


  test_child_window::~test_child_window()
  {
  }

  void test_child_window::create()
  {
    create_window(reinterpret_cast<HWND>(parent_window_.raw_handle()));
  }
  //base_win32_window_t::result_t test_window::on_create(CREATESTRUCT *p)
  //{
  //  return 0;
  //}

}
