﻿#pragma once

#include "sf_windows.h"

namespace sf {
  struct test_child_window : public base_win32_window_t
  {
    test_child_window(
      base_window& parent,
      const std::wstring& title,
      const std::wstring& name,bool fit_to_display,
      float width,float height);
    virtual ~test_child_window();
    virtual void create();
  private:
    base_window& parent_window_;
  };

  struct test_window : public base_win32_window_t
  {
    test_window(
      const std::wstring& title,
      const std::wstring& name,bool fit_to_display,
      float width,float height);
    virtual ~test_window();
    virtual void create();
    virtual result_t on_create(CREATESTRUCT *p)
    {
      base_win32_window_t::on_create(p);
      // 子ウィンドウを生成する
      window_.reset(new test_child_window(*this,L"child",L"child",false,640.0f,480.0f));
      return 0;
    }
    virtual result_t on_left_mouse_button_down(uint32_t mouse_key,int x,int y ) ;//{ return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_left_mouse_button_up(uint32_t mouse_key,int x,int y) ;//{ return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_mouse_move(uint32_t mouse_key,int x,int y);// {return std::is_same<proc_t,wndproc>::value?0:FALSE; }
    virtual result_t on_destroy(){   
      ::PostQuitMessage(0);
      return 0;
    }

    //virtual result_t on_erase_backgroud(HDC dc) {return ::DefWindowProcW(hwnd_,WM_ERASEBKGND,(WPARAM)dc,0);}

    //   virtual result_t on_create(CREATESTRUCT *p);
  private:
    std::unique_ptr<test_child_window> window_;
    test_window();
    int x_,y_;
    bool click_;
  };


}

