﻿/*
==============================================================================

This file is part of the async
Copyright 2005-10 by Satoshi Fujiwara.

async can be redistributed and/or modified under the terms of the
GNU General Public License, as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.

async is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with async; if not, visit www.gnu.org/licenses or write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
Boston, MA 02111-1307 USA

==============================================================================
*/
#include "StdAfx.h"
#include <commctrl.h>

#if _DEBUG
#define _CRTDBG_MAP_ALLOC
#include <crtdbg.h>
#define new new(_NORMAL_BLOCK, __FILE__, __LINE__)
#endif
#include "timer.h"
#include "message_loop.h"
#include "sf_com.h"
#include "application.h"
#include "dout.h"
#pragma comment(lib,"comctl32.lib")

#ifndef HINST_THISCOMPONENT
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
#define HINST_THISCOMPONENT ((HINSTANCE)&__ImageBase)
#endif


using namespace std;

namespace sf {
#ifdef _DEBUG
  std::wstring application::app_id_(L"SF.async_debug");
#else
  std::wstring application::app_id_(L"SF.async");
#endif

  application::application()  
  {
    instance_handle_ = HINST_THISCOMPONENT;
    // ベースディレクトリの取得
    wchar_t dir[MAX_PATH];
    ::GetCurrentDirectoryW(MAX_PATH,dir);
    base_directory_.assign(dir);
  }

  application::~application()
  {
  };

  int application::execute(HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPTSTR    lpCmdLine,
    int       nCmdShow)
  {
#ifdef _DEBUG
    ::_CrtSetDbgFlag(_CRTDBG_LEAK_CHECK_DF | _CRTDBG_ALLOC_MEM_DF);
#endif
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);
    std::wcout.imbue(std::locale(""));

    // 2重起動の防止
    SECURITY_DESCRIPTOR sd;
    InitializeSecurityDescriptor(&sd,SECURITY_DESCRIPTOR_REVISION);
    SetSecurityDescriptorDacl(&sd, TRUE, 0, FALSE);	    
    SECURITY_ATTRIBUTES sec_attr;
    sec_attr.nLength = sizeof (sec_attr);
    sec_attr.lpSecurityDescriptor = &sd;
    sec_attr.bInheritHandle = TRUE; 
#ifdef _DEBUG 
    sf::handle_holder handle(::CreateMutex(&sec_attr, FALSE, _T("async_mutex_debug")));
#else
    sf::handle_holder handle(::CreateMutex(&sec_attr, FALSE, _T("async_mutex")));
#endif

    if(NULL == handle.get() || ::GetLastError() == ERROR_ALREADY_EXISTS)
    {
      return 0;
    }

    // プロセスの優先順位
    SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);

    // コモンコントロールの初期化 
    static const INITCOMMONCONTROLSEX common_ctrls =
    {
      sizeof(INITCOMMONCONTROLSEX),
      ICC_STANDARD_CLASSES | ICC_BAR_CLASSES
    };

    InitCommonControlsEx(&common_ctrls);

    // COMの初期化
    sf::com_initialize init(0,multi_threaded);

    // アプリケーションIDの登録
    sf::throw_if_err<application::exception>()(SetCurrentProcessExplicitAppUserModelID(app_id_.c_str()));

    // タイマー精度の設定
    sf::timer_period tp(1);


    // ウィンドウの作成
    window_.reset(new sf::test_window(
      std::wstring(L"Windowラッパライブラリ"),std::wstring(L"Windowラッパライブラリ"),false,640,480));
    // メッセージループ
    WPARAM ret = sf::run_message_loop()();

    return ret;
  }
}

