
package jp.gr.java_conf.u6k.sample.stg1;

import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class SceneState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        SceneObject o = (SceneObject) ctx.getTarget();

        // 自機生成
        if (o.getTime() == 0) {
            PlayerObject player = new PlayerObject();
            ctx.addStateObject(player);
        }

        // 敵機生成
        if (o.getTime() % 60 == 0) {
            EnemyObject enemy = new EnemyObject();
            ctx.addStateObject(enemy);
        }
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

}
