
package jp.gr.java_conf.u6k.sample.stg1;

import java.awt.event.KeyEvent;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.animation.KeyInfo;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class PlayerMoveState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        PlayerObject o = (PlayerObject) ctx.getTarget();
        double x = o.getX();
        double y = o.getY();

        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        KeyInfo keyInfo = window.getKeyInfo();
        int w = window.getWidth();
        int h = window.getHeight();

        // 計算
        double speed;
        if (keyInfo.isKey(KeyEvent.VK_SHIFT)) {
            speed = 2;
        } else {
            speed = 4;
        }

        if (keyInfo.isKey(KeyEvent.VK_UP)) {
            y -= speed;
        }
        if (keyInfo.isKey(KeyEvent.VK_DOWN)) {
            y += speed;
        }
        if (keyInfo.isKey(KeyEvent.VK_LEFT)) {
            x -= speed;
        }
        if (keyInfo.isKey(KeyEvent.VK_RIGHT)) {
            x += speed;
        }

        if (x < 0) {
            x = 0;
        } else if (x > w) {
            x = w;
        }
        if (y < 0) {
            y = 0;
        } else if (y > h) {
            y = h;
        }

        // 設定
        o.setX(x);
        o.setY(y);
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

}
