
package jp.gr.java_conf.u6k.sample.stg1;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class EnemyBulletDrawState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        EnemyBulletObject o = (EnemyBulletObject) ctx.getTarget();
        double ox = o.getX();
        double oy = o.getY();
        long time = o.getTime();

        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");

        // 描画
        int[] x = new int[4];
        int[] y = new int[4];

        for (int i = 0; i < 4; i++) {
            double angle = 2 * Math.PI / 60 * (time % 60) + 2 * Math.PI / 4 * i;
            x[i] = (int) (5 * Math.cos(angle) + ox);
            y[i] = (int) (5 * Math.sin(angle) + oy);
        }

        window.getCanvas().drawPolygon(x, y, 4);
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

}
