
package jp.gr.java_conf.u6k.sample.stg1;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.state_engine.StateContext;
import jp.gr.java_conf.u6k.state_engine.StateObject;
import jp.gr.java_conf.u6k.state_engine.Transition;

public class EnemyBulletDisposeTransition extends Transition {

    @Override
    public boolean condition(StateObject obj, StateContext ctx) {
        // 取得
        EnemyBulletObject o = (EnemyBulletObject) obj;
        double x = o.getX();
        double y = o.getY();

        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        int w = window.getWidth();
        int h = window.getHeight();

        // 判断
        return (x < 0) || (y < 0) || (x > w) || (y > h);
    }

}
