
package jp.gr.java_conf.u6k.sample.searcher1;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.animation.MouseInfo;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class BallMoveState extends State {

    private final static double a = 0.1;

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        BallObject obj = (BallObject) ctx.getTarget();
        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        MouseInfo mouseInfo = window.getMouseInfo();

        double x = obj.getX();
        double y = obj.getY();
        double speedX = obj.getSpeedX();
        double speedY = obj.getSpeedY();

        // 計算
        if (x > mouseInfo.getX()) {
            speedX -= BallMoveState.a;
        } else if (x < mouseInfo.getX()) {
            speedX += BallMoveState.a;
        }
        if (y > mouseInfo.getY()) {
            speedY -= BallMoveState.a;
        } else if (y < mouseInfo.getY()) {
            speedY += BallMoveState.a;
        }

        x += speedX;
        y += speedY;

        // 設定
        obj.setX(x);
        obj.setY(y);
        obj.setSpeedX(speedX);
        obj.setSpeedY(speedY);
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

}
