
package jp.gr.java_conf.u6k.sample.danmaku2;

import jp.gr.java_conf.u6k.state_engine.StateContext;
import jp.gr.java_conf.u6k.state_engine.StateObject;
import jp.gr.java_conf.u6k.state_engine.Transition;

public class EnemyBulletDisposedTransition extends Transition {

    @Override
    public boolean condition(StateObject obj, StateContext ctx) {
        // 取得
        EnemyBulletObject o = (EnemyBulletObject) obj;

        double x = o.getX();
        double y = o.getY();

        // 判断
        return (x < 0) || (x > 640) || (y < 0) || (y > 480);
    }

}
