
package jp.gr.java_conf.u6k.sample.danmaku2;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.animation.MouseInfo;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class EnemyBodyShotDanmakuState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        EnemyBodyObject obj = (EnemyBodyObject) ctx.getTarget();
        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        MouseInfo mouseInfo = window.getMouseInfo();

        double x = obj.getX();
        double y = obj.getY();

        // 弾幕発射
        for (int i = 0; i < 1; i++) {
            double speed = 5;
            double angle;

            angle = Math.atan2(mouseInfo.getY() - y, mouseInfo.getX() - x);

            EnemyBulletObject bullet = new EnemyBulletObject(x, y, angle, speed);
            ctx.addStateObject(bullet);
        }
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

    @Override
    public void initialize(StateContext ctx) {
    }

}
