
package jp.gr.java_conf.u6k.sample.danmaku1;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.state_engine.StateContext;
import jp.gr.java_conf.u6k.state_engine.StateObject;
import jp.gr.java_conf.u6k.state_engine.Transition;

public class EnemyBulletDisposedTransition extends Transition {

    @Override
    public boolean condition(StateObject obj, StateContext ctx) {
        // 取得
        EnemyBulletObject o = (EnemyBulletObject) obj;
        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");

        double x = o.getX();
        double y = o.getY();

        // 判断
        return (x < 0) || (x > window.getWidth()) || (y < 0) || (y > window.getHeight());
    }

}
