
package jp.gr.java_conf.u6k.sample.danmaku1;

import java.awt.Graphics2D;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class EnemyBodyDrawState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        EnemyBodyObject obj = (EnemyBodyObject) ctx.getTarget();
        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        Graphics2D g = window.getCanvas();

        double x = obj.getX();
        double y = obj.getY();

        // 描画
        g.fillOval((int) x, (int) y, 20, 20);
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

    @Override
    public void initialize(StateContext ctx) {
    }

}
