
package jp.gr.java_conf.u6k.sample.bar;

import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class BarMoveState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        BarObject obj = (BarObject) ctx.getTarget();

        double angle = obj.getAngle();
        double speed = obj.getSpeed();
        double centerX = obj.getCenterX();
        double centerY = obj.getCenterY();
        double x = obj.getX();
        double y = obj.getY();
        double length = obj.getLength();

        // 計算
        x = length * Math.cos(angle) + centerX;
        y = length * Math.sin(angle) + centerY;

        angle += speed;
        if (angle > (2 * Math.PI)) {
            angle -= 2 * Math.PI;
        }

        // 設定
        obj.setX(x);
        obj.setY(y);
        obj.setAngle(angle);
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

    @Override
    public void initialize(StateContext ctx) {
    }

}
