Option Explicit

' ***** O[oϐE萔 *****

Dim LOG_PATH, STACKTRACE_PATH

LOG_PATH = ""
STACKTRACE_PATH = ""

' ***** Jn *****

' Call CompileFile(WScript.Arguments(0))
' Call ExecuteCodeFile(WScript.Arguments(0))
Call TestSuite()






























































' ********************************************************************************
' gbvx֐
' ********************************************************************************

Public Function Parse(strSourceCode)
Call StartFunction("Parse")
	Dim nodProgram
	Dim objTokenizer, colDelimiter, colIgnoreToken
	
	Set colDelimiter = New Collection
	Call colDelimiter.Add(" ")
	Call colDelimiter.Add(vbTab)
	Call colDelimiter.Add(vbCr)
	Call colDelimiter.Add(vbLf)
	Call colDelimiter.Add("{")
	Call colDelimiter.Add("}")
	Call colDelimiter.Add("(")
	Call colDelimiter.Add(")")
	Call colDelimiter.Add(",")
	Call colDelimiter.Add(";")
	Call colDelimiter.Add("+")
	Call colDelimiter.Add("-")
	Call colDelimiter.Add("*")
	Call colDelimiter.Add("/")
	Call colDelimiter.Add("<=")
	Call colDelimiter.Add("<")
	Call colDelimiter.Add(">=")
	Call colDelimiter.Add(">")
	Call colDelimiter.Add("!")
	Call colDelimiter.Add("=")
	Call colDelimiter.Add("""")
	
	Set colIgnoreToken = New Collection
	Call colIgnoreToken.Add(" ")
	Call colIgnoreToken.Add(vbTab)
	Call colIgnoreToken.Add(vbCr)
	Call colIgnoreToken.Add(vbLf)
	
	Set objTokenizer = New Tokenizer
	Call objTokenizer.Initialize(strSourceCode, colDelimiter, colIgnoreToken)
	
	Set nodProgram = New NodeProgram
	Call nodProgram.Parse(objTokenizer)
	
	Set Parse = nodProgram
Call EndFunction()
End Function

Public Function Compile(nodProgram)
Call StartFunction("Compile")
	Dim objContext
	
	Set objContext = New CompileContext
	Call nodProgram.Compile(objContext)
	
	Compile = objContext.ToStringCode()
Call EndFunction()
End Function

Public Sub CompileFile(strSourceCodePath)
	LOG_PATH = strSourceCodePath & ".log"
	STACKTRACE_PATH = strSourceCodePath & ".stacktrace"
	
	Call ClearStackTrace()
	
	Dim strNodeTreePath, strCodePath
	strNodeTreePath = strSourceCodePath & ".tree"
	strCodePath = strSourceCodePath & ".code"
	
	Dim strSourceCode
	strSourceCode = ReadFile(strSourceCodePath)
	
	Dim nodProgram
	Set nodProgram = Parse(strSourceCode)
	
	Call WriteFile(strNodeTreePath, nodProgram.ToString())
	
	Dim strCode
	strCode = Compile(nodProgram)
	
	Call WriteFile(strCodePath, strCode)
	
	Call ClearStackTrace()
End Sub

Public Function ExecuteCode(strCode)
Call StartFunction("ExecuteCode")
	Dim objContext
	
	Set objContext = New VMContext
	Call objContext.Initialize(strCode)
	
	Do While objContext.IsRunning
		Call objContext.Execute()
	Loop
	
	ExecuteCode = objContext.ExitCode
Call EndFunction()
End Function

Public Sub ExecuteCodeFile(strCodePath)
	LOG_PATH = strCodePath & ".log"
	STACKTRACE_PATH = strCodePath & ".stacktrace"
	
	Call ClearStackTrace()
	
	Dim strCode
	Dim objContext
	Dim intCount
	
	strCode = ReadFile(strCodePath)
	
	Set objContext = New VMContext
	Call objContext.Initialize(strCode)
	
	Call WriteLog("--------------------------------------------------------------------------------")
	Call WriteLog("Step: Initialize")
	Call WriteLog("")
	Call WriteLog("Register:")
	Call WriteLog(objContext.ToStringRegister())
	Call WriteLog("")
	Call WriteLog("Memory:")
	Call WriteLog(objContext.ToStringMemory())
	
	intCount = 1
	
	Do While objContext.IsRunning
		Call objContext.Execute()
		
		Call WriteLog("--------------------------------------------------------------------------------")
		Call WriteLog("Step: " & intCount)
		Call WriteLog("")
		Call WriteLog("Register:")
		Call WriteLog(objContext.ToStringRegister())
		Call WriteLog("")
		Call WriteLog("Memory:")
		Call WriteLog(objContext.ToStringMemory())
		
		intCount = intCount + 1
	Loop
	
	Call WriteLog("--------------------------------------------------------------------------------")
	Call WriteLog("ExitCode: " & objContext.ExitCode)
	
	Call ClearStackTrace()
End Sub












































' ********************************************************************************
' ́A\́AR[h
' ********************************************************************************

' ***** ReLXg *****

Class CompileVariableItem
	' ϐB
	Public VariableName
	
	' ubNEXR[vԍB1n܂B
	Public BlockScopeNumber
	
	' ֐XR[vB"Global"܂"Local"B
	Public FunctionScope
	
	' ԍB1n܂B
	Public MemoryNumber
End Class

Class CompileCommandLineItem
	' R}hsBB
	Public CommandLine
	
	' sԍB2pXڂŐݒ肳B
	Public LineNumber
End Class

Class CompileFunctionItem
	' ֐B
	Public FunctionName
	
	' ̐B
	Public ArgumentCount
	
	' xԍB
	Public LabelNumber
End Class

Class CompileContext
	' O[oϐBkey=ϐAvalue=CompileVariableItemCX^XB
	Private pdicGlobalVariable
	
	' [JϐBkey=ϐAvalue=CompileVariableItemCX^XBO[ȍNothingB
	Private pdicLocalVariable
	
	' ֐Bkey=֐ & "," & ̐Avalue=CompileFunctionItemCX^XB
	Private pdicFunction
	
	' R}hsRNVBCompileCommandLineItemCX^Xi[B
	Private pcolCommandLine
	
	' O[õubNEXR[vԍB1n܂AubNɓ邲Ƃ+1A邲Ƃ-1B
	Private pintGlobalBlockScopeNumber
	
	' ֐̃ubNEXR[vԍB1n܂AubNɓ邲Ƃ+1A邲Ƃ-1B
	Private pintLocalBlockScopeNumber
	
	' O[õ[v̏I[xԍ̃RNVB[vɓ邲ƂɃxǉA邲ƂɃx폜B܂AŌ̗vf̃xAݏ̃[v̏I[xB
	Private pcolGlobalLoopLabelNumber
	
	' ֐̃[v̏I[xԍ̃RNVB[vɓ邲ƂɃxǉA邲ƂɃx폜B܂AŌ̗vf̃xAݏ̃[v̏I[xBO[ȍNothingB
	Private pcolLocalLoopLabelNumber
	
	' xԍB1n܂BVxԍvƁA̔ԍ߂A̔ԍ+1B
	Private pintLabelNumber
	
	Private Sub Class_Initialize()
	Call StartFunction("CompileContext.Class_Initialize")
		Set pdicGlobalVariable = CreateObject("Scripting.Dictionary")
		Set pdicLocalVariable = Nothing
		Set pdicFunction = CreateObject("Scripting.Dictionary")
		Set pcolCommandLine = New Collection
		pintGlobalBlockScopeNumber = 1
		pintLocalBlockScopeNumber = 1
		Set pcolGlobalLoopLabelNumber = New Collection
		Set pcolLocalLoopLabelNumber = Nothing
		pintLabelNumber = 1
	Call EndFunction()
	End Sub
	
	Public Property Get FunctionScope()
		If Not pdicLocalVariable Is Nothing Then
			FunctionScope = "Local"
		Else
			FunctionScope = "Global"
		End If
	End Property
	
	Public Sub DeclareVariable(strVariableName)
	Call StartFunction("CompileContext.DeclareVariable")
		Dim objVariableItem
		
		If Not pdicLocalVariable Is Nothing Then
			If pdicLocalVariable.Exists(strVariableName) Then
				Call Err.Raise(1, "CompileContext", "ϐu" & strVariableName & "v́AɃ[JϐŐ錾Ă܂B")
			End If
			
			Set objVariableItem = New CompileVariableItem
			objVariableItem.VariableName = strVariableName
			objVariableItem.BlockScopeNumber = pintLocalBlockScopeNumber
			objVariableItem.FunctionScope = "Local"
			objVariableItem.MemoryNumber = pdicLocalVariable.Count + 1
			
			Call pdicLocalVariable.Add(strVariableName, objVariableItem)
		Else
			If pdicGlobalVariable.Exists(strVariableName) Then
				Call Err.Raise(1, "CompileContext", "ϐu" & strVariableName & "v́AɃO[oϐŐ錾Ă܂B")
			End If
			
			Set objVariableItem = New CompileVariableItem
			objVariableItem.VariableName = strVariableName
			objVariableItem.BlockScopeNumber = pintGlobalBlockScopeNumber
			objVariableItem.FunctionScope = "Global"
			objVariableItem.MemoryNumber = pdicGlobalVariable.Count + 1
			
			Call pdicGlobalVariable.Add(strVariableName, objVariableItem)
		End If
	Call EndFunction()
	End Sub
	
	Public Function IsDeclaredVariable(strVariableName)
	Call StartFunction("CompileContext.IsDeclaredVariable")
		IsDeclaredVariable = False
		
		If Not pdicLocalVariable Is Nothing Then
			If pdicLocalVariable.Exists(strVariableName) Then
				IsDeclaredVariable = True
			End If
		End If
		
		If Not IsDeclaredVariable And pdicGlobalVariable.Exists(strVariableName) Then
			IsDeclaredVariable = True
		End If
	Call EndFunction()
	End Function
	
	Public Function GetVariable(strVariableName)
	Call StartFunction("CompileContext.GetVariable")
		Set GetVariable = Nothing
		
		If Not pdicLocalVariable Is Nothing Then
			If pdicLocalVariable.Exists(strVariableName) Then
				Set GetVariable = pdicLocalVariable(strVariableName)
			End If
		End If
		
		If GetVariable Is Nothing And pdicGlobalVariable.Exists(strVariableName) Then
			Set GetVariable = pdicGlobalVariable(strVariableName)
		End If
		
		If GetVariable Is Nothing Then
			Call Err.Raise(1, "CompileContext", "ϐu" & strVariable & "v͐錾Ă܂B")
		End If
	Call EndFunction()
	End Function
	
	Public Sub DefineFunction(strFunctionName, intArgumentCount)
	Call StartFunction("CompileContext.DefineFunction")
		If Me.IsDefinedFunction(strFunctionName, intArgumentCount) Then
			Call Err.Raise(1, "CompileContext", "֐u" & strFunctionName & "(̐=" & intArgumentCount & ")v͊ɒ`Ă܂B")
		End If
		
		Call pdicFunction.Add(strFunctionName & "," & intArgumentCount, Empty)
	Call EndFunction()
	End Sub
	
	Public Function IsDefinedFunction(strFunctionName, intArgumentCount)
	Call StartFunction("CompileContext.IsDefinedFunction")
		IsDefinedFunction = pdicFunction.Exists(strFunctionName & "," & intArgumentCount)
	Call EndFunction()
	End Function
	
	Public Sub EntryFunction()
	Call StartFunction("CompileContext.EntryFunction")
		If Not pdicLocalVariable Is Nothing Then
			Call Err.Raise(1, "CompileContext", "Ɋ֐ɓĂ܂B")
		End If
		
		Set pdicLocalVariable = CreateObject("Scripting.Dictionary")
		pintLocalVariableBlockScope = 0
		
		Set pcolLocalLoopLabelNumber = New Collection
	Call EndFunction()
	End Sub
	
	Public Sub ExitFunction()
	Call StartFunction("CompileContext.ExitFunction")
		If pdicLocalVariable Is Nothing Then
			Call Err.Raise(1, "CompileContext", "܂֐ɓĂ܂B")
		End If
		
		Set pdicLocalVariable = Nothing
		
		Set pcolLocalLoopLabelNumber = Nothing
	Call EndFunction()
	End Sub
	
	Public Sub EntryBlock()
	Call StartFunction("CompileContext.EntryBlock")
		If Not pdicLocalVariable Is Nothing Then
			pintLocalVariableBlockScope = pintLocalVariableBlockScope + 1
		Else
			pintGlobalVariableBlockScope = pintGlobalVariableBlockScope + 1
		End If
	Call EndFunction()
	End Sub
	
	Public Sub ExitBlock()
	Call StartFunction("CompileContext.ExitBlock")
		If Not pdicLocalVariable Is Nothing Then
			If pintLocalVariableBlockScope = 0 Then
				Call Err.Raise(1, "CompileContext", "ȏA[JϐubNEXR[v܂B")
			End If
			
			pintLocalVariableBlockScope = pintLocalVariableBlockScope - 1
		Else
			If pintGlobalVariableBlockScope = 0 Then
				Call Err.Raise(1, "CompileContext", "ȏAO[oϐubNEXR[v܂B")
			End If
			
			pintGlobalVariableBlockScope = pintGlobalVariableBlockScope - 1
		End If
	Call EndFunction()
	End Sub
	
	Public Sub EntryLoop()
	Call StartFunction("CompileContext.EntryLoop")
		If Not pcolLocalLoopLabelNumber Is Nothing Then
			Call pcolLocalLoopLabelNumber.Add(Me.NewLabelNumber)
		Else
			Call pcolGlobalLoopLabelNumber.Add(Me.NewLabelNumber)
		End If
	Call EndFunction()
	End Sub
	
	Public Sub ExitLoop()
	Call StartFunction("CompileContext.ExitLoop")
		If Not pcolLocalLoopLabelNumber Is Nothing Then
			If pcolLocalLoopLabelNumber.Count = 0 Then
				Call Err.Raise(1, "CompileContext", "܂[vɓĂ܂B")
			End If
			
			Call pcolLocalLoopLabelNumber.RemoveLast()
		Else
			If pcolGlobalLoopLabelNumber.Count = 0 Then
				Call Err.Raise(1, "CompileContext", "܂[vɓĂ܂B")
			End If
			
			Call pcolGlobalLoopLabelNumber.RemoveLast()
		End If
	Call EndFunction()
	End Sub
	
	Private Sub AddCommandLine(strCommandLine)
	Call StartFunction("CompileContext.AddCommandLine")
		Dim objCommandLineItem
		
		Set objCommandLineItem = New CompileCommandLineItem
		objCommandLineItem.CommandLine = strCommandLine
		objCommandLineItem.LineNumber = 0
		
		Call pcolCommandLine.Add(objCommandLineItem)
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLinePushValue(strType, strValue)
	Call StartFunction("CompileContext.AddCommandLinePushValue")
		If strType <> "number" _
			And strType <> "string" _
			And strType <> "bool" _
			And strType <> "null" Then
			
			Call Err.Raise(1, "CompileContext", "l̎ނunumbervustringvuboolvł͂܂B[" & strType & "]")
		End If
		
		If strType = "number" And Not IsNumberToken(strValue) Then
			Call Err.Raise(1, "CompileContext", "number^̒ll`ł͂܂B[" & strValue & "]")
		ElseIf strType = "bool" And strValue <> "true" And strValue <> "false" Then
			Call Err.Raise(1, "CompileContext", "bool^̒l^l`ł͂܂B[" & strValue & "]")
		ElseIf strType = "null" And strValue <> "" Then
			Call Err.Raise(1, "CompileContext", "null^̒lł͂܂B[" & strValue & "]")
		End If
		
		Call AddCommandLine("push value," & strType & "|" & strValue)
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLinePushGlobalVariable(strAddress)
	Call StartFunction("CompileContext.AddCommandLinePushGlobalVariable")
		If Not IsIntegerToken(strAddress) Then
			Call Err.Raise(1, "CompileContext", "AhXԍ`ł͂܂B[" & strAddress & "]")
		End If
		
		Call AddCommandLine("push global variable," & strAddress)
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLinePushLocalVariable(strAddress)
	Call StartFunction("CompileContext.AddCommandLinePushLocalVariable")
		If Not IsIntegerToken(strAddress) Then
			Call Err.Raise(1, "CompileContext", "AhXԍ`ł͂܂B[" & strAddress & "]")
		End If
		
		Call AddCommandLine("push local variable," & strAddress)
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLinePop()
	Call StartFunction("CompileContext.AddCommandLinePop")
		Call AddCommandLine("pop")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLinePopGlobalVariable(strAddress)
	Call StartFunction("CompileContext.AddCommandLinePopGlobalVariable")
		If Not IsIntegerToken(strAddress) Then
			Call Err.Raise(1, "CompileContext", "AhXԍ`ł͂܂B[" & strAddress & "]")
		End If
		
		Call AddCommandLine("pop global variable," & strAddress)
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLinePopLocalVariable(strAddress)
	Call StartFunction("CompileContext.AddCommandLinePopLocalVariable")
		If Not IsIntegerToken(strAddress) Then
			Call Err.Raise(1, "CompileContext", "AhXԍ`ł͂܂B[" & strAddress & "]")
		End If
		
		Call AddCommandLine("pop local variable," & strAddress)
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineCallNativeFunction(strFunctionName, strArgumentCount)
	Call StartFunction("CompileContext.AddCommandLineCallNativeFunction")
		If Not IsIdentifierToken(strFunctionName) Then
			Call Err.Raise(1, "CompileContext", "֐ʎq`ł͂܂B[" & strFunctionName & "]")
		End If
		
		Call AddCommandLine("call native function," & strFunctionName & "," & strArgumentCount)
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineReturn()
	Call StartFunction("CompileContext.AddCommandLineReturn")
		Call AddCommandLine("return")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineExit()
	Call StartFunction("CompileContext.AddCommandLineExit")
		Call AddCommandLine("exit")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineAdd()
	Call StartFunction("CompileContext.AddCommandLineAdd")
		Call AddCommandLine("add")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineSubtract()
	Call StartFunction("CompileContext.AddCommandLineSubtract")
		Call AddCommandLine("subtract")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineMultiple()
	Call StartFunction("CompileContext.AddCommandLineMultiple")
		Call AddCommandLine("multiple")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineDivide()
	Call StartFunction("CompileContext.AddCommandLineDivide")
		Call AddCommandLine("divide")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineGreaterThan()
	Call StartFunction("CompileContext.AddCommandLineGreaterThan")
		Call AddCommandLine("greater than")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineLessThan()
	Call StartFunction("CompileContext.AddCommandLineLessThan")
		Call AddCommandLine("less than")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineEqual()
	Call StartFunction("CompileContext.AddCommandLineEqual")
		Call AddCommandLine("equal")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineAnd()
	Call StartFunction("CompileContext.AddCommandLineAnd")
		Call AddCommandLine("and")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineOr()
	Call StartFunction("CompileContext.AddCommandLineOr")
		Call AddCommandLine("or")
	Call EndFunction()
	End Sub
	
	Public Sub AddCommandLineNot()
	Call StartFunction("CompileContext.AddCommandLineNot")
		Call AddCommandLine("not")
	Call EndFunction()
	End Sub
	
	Public Function NewLabelNumber()
	Call StartFunction("CompileContext.NewLabelNumber")
		NewLabelNumber = pintLabelNumber
		
		pintLabelNumber = pintLabelNumber + 1
	Call EndFunction()
	End Function
	
	Public Function GetLastLoopLabelNumber()
	Call StartFunction("CompileContext.GetLastLoopLabelNumber")
		If Not pcolLocalLoopLabelNumber Is Nothing Then
			If pcolLocalLoopLabelNumber.Count = 0 Then
				Call Err.Raise(1, "CompileContext", "܂[vɓĂ܂B")
			End If
			
			GetLastLoopLabelNumber = pcolLocalLoopLabelNumber.Item(pcolLocalLoopLabelNumber.Count)
		Else
			If pcolGlobalLoopLabelNumber.Count = 0 Then
				Call Err.Raise(1, "CompileContext", "܂[vɓĂ܂B")
			End If
			
			GetLastLoopLabelNumber = pcolGlobalLoopLabelNumber.Item(pcolGlobalLoopLabelNumber.Count)
		End If
	Call EndFunction()
	End Function
	
	Public Function GetFunctionLabelNumber(strFunctionName, intArgumentCount)
	Call StartFunction("CompileContext.GetFunctionLabelNumber")
		If Not pdicFunction.Exists(strFunctionName & "," & intArgumentCount) Then
			Call Err.Raise(1, "CompileContext", "֐u" & strFunctionName & "(̐=" & intArgumentCount & ")v́A`Ă܂B")
		End If
		
		GetFunctionLabelNumber = pdicFunction(strFunctionName & "," & intArgumentCount)
	Call EndFunction()
	End Function
	
	Public Function GetLastCommandLine()
	Call StartFunction("CompileContext.GetLastCommandLine")
		If pcolCommandLine.Count > 0 Then
			GetLastCommandLine = pcolCommandLine.Item(pcolCommandLine.Count).CommandLine
		Else
			GetLastCommandLine = ""
		End If
	Call EndFunction()
	End Function
	
	Public Function ToStringCode()
	Call StartFunction("CompileContext.ToStringCode")
		ToStringCode = ""
		
		Dim objCommandLine
		For Each objCommandLine In pcolCommandLine.Items
			ToStringCode = ToStringCode & objCommandLine.CommandLine & vbCrLf
		Next
	Call EndFunction()
	End Function
End Class

' ***** m[h *****

Class NodeBool
	Private pstrValue
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeBool.Parse")
		If objTokenizer.CurrentToken = "true" Or objTokenizer.CurrentToken = "false" Then
			pstrValue = objTokenizer.CurrentToken
		Else
			Call Err.Raise(1, "NodeBool.vbs", "L[[hutruev܂́ufalsev܂B(ǂݎ=" & objTokenizer.CurrentToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeBool.Compile")
		Call objContext.AddCommandLinePushValue("bool", pstrValue)
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeBool.ToString")
		ToString = "bool: " & pstrValue & vbCrLf
	Call EndFunction()
	End Function
End Class

Class NodeBreakStatement
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeBreakStatement.Parse")
		If objTokenizer.CurrentToken <> "break" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[hubreakv܂B(ǂݎ=" & objTokenizer.CurrentToken & ")")
		End If
		
		If objTokenizer.MoveNextToken <> ";" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[hu;v܂B(ǂݎ=" & objTokenizer.CurrentToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeBreakStatement.Compile")
		Call objContext.AddCommandLine("goto," & objContext.GetLastLoopLabelNumber())
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeBreakStatement.ToString")
		ToString = "break:"
	Call EndFunction()
	End Function
End Class

Class NodeCallFunction
	Private pstrFunctionName
	Private pcolNodExpression
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeCallFunction.Parse")
		Dim strToken
		Dim nodExpression
		
		pstrFunctionName = objTokenizer.CurrentToken
		If Not IsIdentifierToken(pstrFunctionName) Then
			Call Err.Raise(1, "NodeCallFunction", "֐ʎq̌`ł͂܂B(ǂݎ=" & pstrFunctionName & ")")
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> "(" Then
			Call Err.Raise(1, "NodeCallFunction", "L[[hu(v܂B(ǂݎ=" & strToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
		
		Set pcolNodExpression = New Collection
		
		Do While True
			strToken = objTokenizer.CurrentToken
			If strToken = ")" Then
				Exit Do
			End If
			
			If pcolNodExpression.Count > 0 Then
				If strToken <> "," Then
					Call Err.Raise(1, "NodeCallFunction", "L[[hu,v܂B(ǂݎ=" & strToken & ")")
				End If
			End If
			
			Set nodExpression = New NodeExpression
			Call nodExpression.Parse(objTokenizer)
			
			Call pcolNodExpression.Add(nodExpression)
		Loop
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeCallFunction.Compile")
		If Not objContext.IsDefinedFunction(pstrFunctionName, pcolNodExpression.Count) Then
			Call Err.Raise(1, "NodeCallFunction", "֐u" & pstrFunctionName & "(̐=" & pcolNodExpression.Count & ")v͒`Ă܂B")
		End If
		
		Dim nodExpression
		
		For Each nodExpression In pcolNodExpression.Items
			Call nodExpression.Compile(objContext)
		Next
		
		Call objContext.AddCommandLine("call function," & pstrFunctionName & "," & pcolNodExpression.Count)
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeCallFunction.ToString")
		ToString = "call function: " & vbCrLf _
			& " name: " & pstrFunctionName & vbCrLf
		
		Dim nodExpression
		For Each nodExpression In pcolNodExpression.Items
			ToString = ToString & " arg:" & vbCrLf _
				& StringAddIndent(StringAddIndent(nodExpression.ToString()))
		Next
	Call EndFunction()
	End Function
End Class

Class NodeCallNativeFunction
	Private pstrFunctionName
	Private pcolNodExpression
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeCallNativeFunction.Parse")
		Dim strToken
		Dim nodExpression
		
		strToken = objTokenizer.CurrentToken
		If strToken <> "native" Then
			Call Err.Raise(1, "NodeCallNativeFunction", "L[[hunativev܂B(ǂݎ=" & strToken & ")")
		End If
		
		pstrFunctionName = objTokenizer.MoveNextToken
		If Not IsIdentifierToken(pstrFunctionName) Then
			Call Err.Raise(1, "NodeCallNativeFunction", "֐ʎq̌`ł͂܂B(ǂݎ=" & pstrFunctionName & ")")
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> "(" Then
			Call Err.Raise(1, "NodeCallNativeFunction", "L[[hu(v܂B(ǂݎ=" & strToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
		
		Set pcolNodExpression = New Collection
		
		Do While True
			strToken = objTokenizer.CurrentToken
			If strToken = ")" Then
				Exit Do
			End If
			
			If pcolNodExpression.Count > 0 Then
				If strToken <> "," Then
					Call Err.Raise(1, "NodeCallNativeFunction", "L[[hu,v܂B(ǂݎ=" & strToken & ")")
				End If
			End If
			
			Set nodExpression = New NodeExpression
			Call nodExpression.Parse(objTokenizer)
			
			Call pcolNodExpression.Add(nodExpression)
		Loop
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeCallNativeFunction.Compile")
		Dim nodExpression
		For Each nodExpression In pcolNodExpression.Items
			Call nodExpression.Compile(objContext)
		Next
		
		Call objContext.AddCommandLineCallNativeFunction(pstrFunctionName, pcolNodExpression.Count)
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeCallNativeFunction.ToString")
		ToString = "call native function: " & vbCrLf _
			& " name: " & pstrFunctionName & vbCrLf
		
		Dim nodExpression
		For Each nodExpression In pcolNodExpression.Items
			ToString = ToString & " arg:" & vbCrLf _
				& StringAddIndent(StringAddIndent(nodExpression.ToString()))
		Next
	Call EndFunction()
	End Function
End Class

Class NodeDeclareVariable
	Private pdicVariable
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeDeclareVariable.Parse")
		Dim strToken
		Dim strVariableName
		Dim nodInitExpression
		
		strToken = objTokenizer.CurrentToken
		If strToken <> "var" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[huvarv܂B(ǂݎ=" & strToken & ")")
		End If
		
		Set pdicVariable = CreateObject("Scripting.Dictionary")
		
		Do While True
			strVariableName = objTokenizer.MoveNextToken
			If Not IsIdentifierToken(strVariableName) Then
				Call Err.Raise(1, "Runtime.vbs", "ϐʎq̌`ł͂܂B(ǂݎ=" & strVariableName & ")")
			End If
			
			strToken = objTokenizer.MoveNextToken
			If strToken = "=" Then
				Call objTokenizer.MoveNextToken
				
				Set nodInitExpression = New NodeExpression
				Call nodInitExpression.Parse(objTokenizer)
				
				Call pdicVariable.Add(strVariableName, nodInitExpression)
				
				strToken = objTokenizer.CurrentToken
			Else
				Call pdicVariable.Add(strVariableName, Nothing)
			End If
			If strToken = ";" Then
				Exit Do
			End If
			If strToken <> "," Then
				Call Err.Raise(1, "Runtime.vbs", "L[[hu,v܂B(ǂݎ=" & strToken & ")")
			End If
		Loop
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeDeclareVariable.Compile")
		Dim strVariableName
		Dim nodInitExpression
		Dim objVariable
		
		For Each strVariableName In pdicVariable.Keys
			Set nodInitExpression = pdicVariable(strVariableName)
			
			If Not nodInitExpression Is Nothing Then
				Call nodInitExpression.Compile(objContext)
				
				Call objContext.DeclareVariable(strVariableName)
				
				Set objVariable = objContext.GetVariable(strVariableName)
				
				If objVariable.FunctionScope = "Global" Then
					Call objContext.AddCommandLinePopGlobalVariable(objVariable.MemoryNumber)
				Else
					Call objContext.AddCommandLinePopLocalVariable(objVariable.MemoryNumber)
				End If
			Else
				Call objContext.DeclareVariable(strVariableName)
			End If
		Next
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeDeclareVariable.ToString")
		Dim strText
		strText = "declare variable:" & vbCrLf
		
		Dim strVariableName
		For Each strVariableName In pdicVariable.Keys
			strText = strText & " name: " & strVariableName & vbCrLf
			
			If Not pdicVariable(strVariableName) Is Nothing Then
				strText = strText & StringAddIndent(StringAddIndent(pdicVariable(strVariableName).ToString()))
			End If
		Next
		
		ToString = strText
	Call EndFunction()
	End Function
End Class

Class NodeExpression
	Private pnodExpression
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeExpression.Parse")
		Set pnodExpression = New NodeExpressionAssign
		Call pnodExpression.Parse(objTokenizer)
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeExpression.Compile")
		Call pnodExpression.Compile(objContext)
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeExpression.ToString")
		ToString = pnodExpression.ToString()
	Call EndFunction()
	End Function
End Class

Class NodeExpressionAdd
	Private pstrFugou
	Private pnodOperand1
	Private pstrOperator
	Private pnodOperand2
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeExpressionAdd.Parse")
		pstrFugou = objTokenizer.CurrentToken
		If pstrFugou = "+" Or pstrFugou = "-" Then
			Call objTokenizer.MoveNextToken
		Else
			pstrFugou = Empty
		End If
		
		Set pnodOperand1 = New NodeExpressionMultiple
		Call pnodOperand1.Parse(objTokenizer)
		
		pstrOperator = objTokenizer.CurrentToken
		If pstrOperator = "+" Or pstrOperator = "-" Then
			Call objTokenizer.MoveNextToken
			
			Set pnodOperand2 = New NodeExpressionAdd
			Call pnodOperand2.Parse(objTokenizer)
		Else
			pstrOperator = Empty
			Set pnodOperand2 = Nothing
		End If
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeExpressionAdd.Compile")
		' TODO RpCĂȂB
		Call pnodOperand1.Compile(objContext)
		
		If pstrOperator <> Empty Then
			Call pnodOperand2.Compile(objContext)
			
			If pstrOperator = "+" Then
				Call objContext.AddCommandLineAdd()
			Else
				Call objContext.AddCommandLineSubtract()
			End If
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeExpressionAdd.ToString")
		ToString = "expression(+, -):" & vbCrLf
		
		If pstrFugou <> Empty Then
			ToString = ToString & " fugou: " & pstrFugou & vbCrLf
		End If
		
		ToString = ToString & StringAddIndent(pnodOperand1.ToString())
		
		If pstrOperator <> Empty Then
			ToString = ToString & " operator: " & pstrOperator & vbCrLf _
				& StringAddIndent(pnodOperand2.ToString())
		End If
	Call EndFunction()
	End Function
End Class

Class NodeExpressionAssign
	Private pstrVariableName
	Private pstrOperator
	Private pnodExpression
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeExpressionAssign.Parse")
		If objTokenizer.Peek() = "=" Then
			pstrVariableName = objTokenizer.CurrentToken
			If Not IsIdentifierToken(pstrVariableName) Then
				Call Err.Raise(1, "NodeExpressionAssign", "ϐʎq̌`ł͂܂B")
			End If
			
			pstrOperator = objTokenizer.MoveNextToken
			
			Call objTokenizer.MoveNextToken
			
			Set pnodExpression = New NodeExpression
			Call pnodExpression.Parse(objTokenizer)
		Else
			pstrVariableName = Empty
			pstrOperator = Empty
			
			Set pnodExpression = New NodeExpressionEqual
			Call pnodExpression.Parse(objTokenizer)
		End If
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeExpressionAssign.Compile")
		Dim objVariable
		
		Call pnodExpression.Compile(objContext)
		
		If pstrVariableName <> Empty Then
			If Not objContext.IsDeclaredVariable(pstrVariableName) Then
				Call Err.Raise(1, "NodeExpressionAssign", "ϐu" & pstrVariableName & "v͐錾Ă܂B")
			End If
			
			Set objVariable = objContext.GetVariable(pstrVariableName)
			If objVariable.FunctionScope = "Global" Then
				Call objContext.AddCommandLinePopGlobalVariable(objVariable.MemoryNumber)
				Call objContext.AddCommandLinePushGlobalVariable(objVariable.MemoryNumber)
			Else
				Call objContext.AddCommandLinePopLocalVariable(objVariable.MemoryNumber)
				Call objContext.AddCommandLinePushLocalVariable(objVariable.MemoryNumber)
			End If
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeExpressionAssign.ToString")
		ToString = "expression(=):" & vbCrLf
		
		If pstrVariableName <> Empty Then
			ToString = ToString & " variable: " & pstrVariableName & vbCrLf _
				& " operator: " & pstrOperator & vbCrLf
		End If
		
		ToString = ToString & StringAddIndent(pnodExpression.ToString())
	Call EndFunction()
	End Function
End Class

Class NodeExpressionCompare
	Private pnodOperand1
	Private pstrOperator
	Private pnodOperand2
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeExpressionCompare.Parse")
		Set pnodOperand1 = New NodeExpressionAdd
		Call pnodOperand1.Parse(objTokenizer)
		
		pstrOperator = objTokenizer.CurrentToken
		If pstrOperator = "<" Or pstrOperator = "<=" Or pstrOperator = ">" Or pstrOperator = ">=" Then
			Call objTokenizer.MoveNextToken
			
			Set pnodOperand2 = New NodeExpressionCompare
			Call pnodOperand2.Parse(objTokenizer)
		Else
			pstrOperator = Empty
			Set pnodOperand2 = Nothing
		End If
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeExpressionCompare.Compile")
		Call pnodOperand1.Compile(objContext)
		
		If pstrOperator <> Empty Then
			Call pnodOperand2.Compile(objContext)
			
			If pstrOperator = "<" Then
				Call objContext.AddCommandLineLessThan()
			ElseIf pstrOperator = ">" Then
				Call objContext.AddCommandLineGreaterThan()
			ElseIf pstrOperator = "<=" Then
				Call objContext.AddCommandLineLessThan()
				Call pnodOperand1.Compile(objContext)
				Call pnodOperand2.Compile(objContext)
				Call objContext.AddCommandLineEqual()
				Call objContext.AddCommandLineOr()
			Else
				Call objContext.AddCommandLineGreaterThan()
				Call pnodOperand1.Compile(objContext)
				Call pnodOperand2.Compile(objContext)
				Call objContext.AddCommandLineEqual()
				Call objContext.AddCommandLineOr()
			End If
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeExpressionCompare.ToString")
		ToString = "expression(<, <=, >, >=):" & vbCrLf _
			& StringAddIndent(pnodOperand1.ToString())
		
		If pstrOperator <> Empty Then
			ToString = ToString & " operator: " & pstrOperator & vbCrLf _
				& StringAddIndent(pnodOperand2.ToString())
		End If
	Call EndFunction()
	End Function
End Class

Class NodeExpressionEqual
	Private pnodOperand1
	Private pstrOperator
	Private pnodOperand2
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeExpressionEqual.Parse")
		Set pnodOperand1 = New NodeExpressionCompare
		Call pnodOperand1.Parse(objTokenizer)
		
		pstrOperator = objTokenizer.CurrentToken
		If pstrOperator = "==" Or pstrOperator = "!=" Then
			Call objTokenizer.MoveNextToken
			
			Set pnodOperand2 = New NodeExpressionEqual
			Call pnodOperand2.Parse(objTokenizer)
		Else
			pstrOperator = Empty
			Set pnodOperand2 = Nothing
		End If
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeExpressionEqual.Compile")
		Call pnodOperand1.Compile(objContext)
		
		If pstrOperator <> Empty Then
			Call pnodOperand2.Compile(objContext)
			
			If pstrOperator = "==" Then
				Call objContext.AddCommandLineEqual()
			Else
				Call objContext.AddCommandLineEqual()
				Call objContext.AddCommandLineNot()
			End If
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeExpressionEqual.ToString")
		ToString = "expression(==, !=):" & vbCrLf _
			& StringAddIndent(pnodOperand1.ToString())
		
		If pstrOperator <> Empty Then
			ToString = ToString & " operator: " & pstrOperator & vbCrLf _
				& StringAddIndent(pnodOperand2.ToString())
		End If
	Call EndFunction()
	End Function
End Class

Class NodeExpressionMultiple
	Private pnodOperand1
	Private pstrOperator
	Private pnodOperand2
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeExpressionMultiple.Parse")
		Set pnodOperand1 = New NodeOperand
		Call pnodOperand1.Parse(objTokenizer)
		
		pstrOperator = objTokenizer.CurrentToken
		If pstrOperator = "*" Or pstrOperator = "/" Then
			Call objTokenizer.MoveNextToken
			
			Set pnodOperand2 = New NodeExpressionMultiple
			Call pnodOperand2.Parse(objTokenizer)
		Else
			pstrOperator = Empty
			Set pnodOperand2 = Nothing
		End If
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeExpressionMultiple.Compile")
		Call pnodOperand1.Compile(objContext)
		
		If pstrOperator <> Empty Then
			Call pnodOperand2.Compile(objContext)
			
			If pstrOperator = "*" Then
				Call objContext.AddCommandLineMultiple()
			Else
				Call objContext.AddCommandLineDivide()
			End If
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeExpressionMultiple.ToString")
		ToString = "expression(*, /):" & vbCrLf _
			& StringAddIndent(pnodOperand1.ToString())
		
		If pstrOperator <> Empty Then
			ToString = ToString & " operator: " & pstrOperator & vbCrLf _
				& StringAddIndent(pnodOperand2.ToString())
		End If
	Call EndFunction()
	End Function
End Class

Class NodeForEachStatement
	Private pstrVariableName
	Private pnodExpression
	Private pnodLoopStatementBlock
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeForEachStatement.Parse")
		Dim strToken
		
		strToken = objTokenizer.CurrentToken
		If strToken <> "foreach" Then
			Call Err.Raise(1, "NodeForEachStatement", "L[[huforeachv܂B(ǂݎ=" & strToken & ")")
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> "(" Then
			Call Err.Raise(1, "NodeForEachStatement", "L[[hu(v܂B(ǂݎ=" & strToken & ")")
		End If
		
		pstrVariableName = objTokenizer.MoveNextToken
		If Not IsIdentifierToken(pstrVariableName) Then
			Call Err.Raise(1, "NodeForEachStatement", "ϐʎq̌`ł͂܂B(ǂݎ=" & pstrVariableName & ")")
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> "in" Then
			Call Err.Raise(1, "NodeForEachStatement", "L[[huinv܂B(ǂݎ=" & strToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
		
		Set pnodExpression = New NodeExpression
		Call pnodExpression.Parse(objTokenizer)
		
		strToken = objTokenizer.CurrentToken
		If strToken <> ")" Then
			Call Err.Raise(1, "NodeForEachStatement", "L[[hu)v܂B(ǂݎ=" & strToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
		
		Set pnodLoopStatementBlock = New NodeLoopStatementBlock
		Call pnodLoopStatementBlock.Parse(objTokenizer)
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeForEachStatement.Compile")
		' TODO 
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeForEachStatement.ToString")
		ToString = "foreach:" & vbCrLf _
			& " variable: " & pstrVariableName & vbCrLf _
			& StringAddIndent(pnodExpression.ToString()) _
			& StringAddIndent(pnodLoopStatementBlock.ToString())
	Call EndFunction()
	End Function
End Class

Class NodeForStatement
	Private pnodInitExpression
	Private pnodIfExpression
	Private pnodIterateExpression
	Private pnodLoopStatementBlock
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeForStatement.Parse")
		Dim strToken
		
		strToken = objTokenizer.CurrentToken
		If strToken <> "for" Then
			Call Err.Raise(1, "NodeForStatement.vbs", "L[[huforv܂B(ǂݎ=" & strToken & ")")
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> "(" Then
			Call Err.Raise(1, "NodeForStatement.vbs", "L[[hu(v܂B(ǂݎ=" & strToken & ")")
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> ";" Then
			Set pnodInitExpression = New NodeExpression
			Call pnodInitExpression.Parse(objTokenizer)
			
			strToken = objTokenizer.CurrentToken
			If strToken <> ";" Then
				Call Err.Raise(1, "NodeForStatement.vbs", "L[[hu;v܂B(ǂݎ=" & strToken & ")")
			End If
		Else
			Set pnodInitExpression = Nothing
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> ";" Then
			Set pnodIfExpression = New NodeExpression
			Call pnodIfExpression.Parse(objTokenizer)
			
			strToken = objTokenizer.CurrentToken
			If strToken <> ";" Then
				Call Err.Raise(1, "NodeForStatement.vbs", "L[[hu;v܂B(ǂݎ=" & strToken & ")")
			End If
		Else
			Set pnodIfExpression = Nothing
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> ")" Then
			Set pnodIterateExpression = New NodeExpression
			Call pnodIterateExpression.Parse(objTokenizer)
			
			strToken = objTokenizer.CurrentToken
			If strToken <> ")" Then
				Call Err.Raise(1, "NodeForStatement.vbs", "L[[hu)v܂B(ǂݎ=" & strToken & ")")
			End If
		Else
			Set pnodIterateExpression = Nothing
		End If
		
		Call objTokenizer.MoveNextToken
		
		Set pnodLoopStatementBlock = New NodeLoopStatementBlock
		Call pnodLoopStatementBlock.Parse(objTokenizer)
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeForStatement.Compile")
		' TODO B
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeForStatement.ToString")
		ToString = "for:" & vbCrLf
		
		If Not pnodInitExpression Is Nothing Then
			ToString = ToString & " init expr:" & vbCrLf _
				& StringAddIndent(StringAddIndent(pnodInitExpression.ToString()))
		End If
		
		If Not pnodIfExpression Is Nothing Then
			ToString = ToString & " if expr:" & vbCrLf _
				& StringAddIndent(StringAddIndent(pnodIfExpression.ToString()))
		End If
		
		If Not pnodIterateExpression Is Nothing Then
			ToString = ToString & " iterate expr:" & vbCrLf _
				& StringAddIndent(StringAddIndent(pnodIterateExpression.ToString()))
		End If
		
		ToString = ToString & StringAddIndent(pnodLoopStatementBlock.ToString())
	Call EndFunction()
	End Function
End Class

Class NodeFunction
	Private pstrFunctionName
	Private pcolStrArgument
	Private pnodStatementBlock
	
	Public Property Get FunctionName()
		FunctionName = pstrFunctionName
	End Property
	
	Public Property Get Arguments()
		Set Arguments = pcolStrArgument
	End Property
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeFunction.Parse")
		Dim strToken
		
		strToken = objTokenizer.CurrentToken
		If strToken <> "function" Then
			Call Err.Raise(1, "NodeFunction", "L[[hufunctionv܂B(ǂݎ=" & strToken & ")")
		End If
		
		pstrFunctionName = objTokenizer.MoveNextToken
		If Not IsIdentifierToken(pstrFunctionName) Then
			Call Err.Raise(1, "NodeFunction", "֐ʎq̌`ł͂܂B(ǂݎ=" & pstrFunctionName & ")")
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> "(" Then
			Call Err.Raise(1, "NodeFunction", "L[[hu(v܂B(ǂݎ=" & strToken & ")")
		End If
		
		Set pcolStrArgument = New Collection
		
		Do While True
			strToken = objTokenizer.MoveNextToken
			If strToken = ")" Then
				Exit Do
			End If
			
			If pcolStrArgument.Count > 0 Then
				If strToken <> "," Then
					Call Err.Raise(1, "NodeFunction", "L[[hu,v܂B(ǂݎ=" & strToken & ")")
				End If
				
				strToken = objTokenizer.MoveNextToken
			End If
			
			If Not IsIdentifierToken(strToken) Then
				Call Err.Raise(1, "NodeFunction", "ʎq̌`ł͂܂B(ǂݎ=" & strToken & ")")
			End If
			
			Call pcolStrArgument.Add(strToken)
		Loop
		
		Call objTokenizer.MoveNextToken
		
		Set pnodStatementBlock = New NodeStatementBlock
		Call pnodStatementBlock.Parse(objTokenizer)
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeFunction.Compile")
		Call objContext.EntryFunction()
		
		Call objContext.AddCommandLine("start function," & pstrFunctionName & "," & pcolStrArgument.Count)
		
		Dim intCount
		For intCount = pcolStrArgument.Count To 1 Step -1
			Call objContext.AddCommandLine("declare variable," & pcolStrArgument.Item(intCount))
			Call objContext.DeclareVariable(pcolStrArgument.Item(intCount))
			
			Call objContext.AddCommandLine("assign," & pcolStrArgument.Item(intCount))
			Call objContext.AddCommandLine("pop")
		Next
		
		Call pnodStatementBlock.Compile(objContext)
		
		If objContext.GetLastCommandLine <> "return" Then
			Call objContext.AddCommandLine("push,null")
			Call objContext.AddCommandLine("return")
		End If
		
		Call objContext.ExitFunction()
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeFunction.ToString")
		ToString = "function:" & vbCrLf _
			& " name: " & pstrFunctionName & vbCrLf
		
		Dim strArgument
		For Each strArgument In pcolStrArgument.Items
			ToString = ToString & " arg: " & strArgument & vbCrLf
		Next
		
		ToString = ToString & StringAddIndent(StringAddIndent(pnodStatementBlock.ToString()))
	Call EndFunction()
	End Function
End Class

Class NodeIfStatement
	Private pcolNodIfExpression
	Private pcolNodStatementBlock
	Private pnodElseStatementBlock
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeIfStatement.Parse")
		Dim strToken
		Dim nodExpression
		Dim nodStatementBlock
		
		strToken = objTokenizer.CurrentToken
		If strToken <> "if" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[huifv܂B(ǂݎ=" & strToken & ")")
		End If
		
		Set pcolNodIfExpression = New Collection
		Set pcolNodStatementBlock = New Collection
		Set pnodElseStatementBlock = Nothing
		
		Do While True
			strToken = objTokenizer.MoveNextToken
			If strToken <> "(" Then
				Call Err.Raise(1, "Runtime.vbs", "L[[hu(v܂B(ǂݎ=" & strToken & ")")
			End If
			
			Call objTokenizer.MoveNextToken
			
			Set nodExpression = New NodeExpression
			Call nodExpression.Parse(objTokenizer)
			
			Call pcolNodIfExpression.Add(nodExpression)
			
			strToken = objTokenizer.CurrentToken
			If strToken <> ")" Then
				Call Err.Raise(1, "Runtime.vbs", "L[[hu)v܂B(ǂݎ=" & strToken & ")")
			End If
			
			Call objTokenizer.MoveNextToken
			
			Set nodStatementBlock = New NodeStatementBlock
			Call nodStatementBlock.Parse(objTokenizer)
			
			Call pcolNodStatementBlock.Add(nodStatementBlock)
			
			strToken = objTokenizer.CurrentToken
			If strToken <> "else" Then
				Exit Do
			End If
			
			strToken = objTokenizer.MoveNextToken
			If strToken <> "if" Then
				Set pnodElseStatementBlock = New NodeStatementBlock
				Call pnodElseStatementBlock.Parse(objTokenizer)
				
				Exit Do
			End If
		Loop
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeIfStatement.Compile")
		' TODO B
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeIfStatement.ToString")
		ToString = ""
		
		Dim intCount
		For intCount = 1 To pcolNodIfExpression.Count
			If intCount = 1 Then
				ToString = "if:" & vbCrLf
			Else
				ToString = ToString & "else if:" & vbCrLf
			End If
			ToString = ToString & StringAddIndent(pcolNodIfExpression.Item(intCount).ToString()) _
				& StringAddIndent(pcolNodStatementBlock.Item(intCount).ToString())
		Next
		
		If Not pnodElseStatementBlock Is Nothing Then
			ToString = ToString & "else:" & vbCrLf _
				& StringAddIndent(pnodElseStatementBlock.ToString())
		End If
	Call EndFunction()
	End Function
End Class

Class NodeLoopStatementBlock
	Private pcolNodStatement
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeLoopStatementBlock.Parse")
		Dim strToken
		Dim nodStatement
		
		strToken = objTokenizer.CurrentToken
		If strToken <> "{" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[hu{v܂B(ǂݎ=" & strToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
		
		Set pcolNodStatement = New Collection
		
		Do While True
			strToken = objTokenizer.CurrentToken
			If strToken = "}" Then
				Exit Do
			End If
			
			If objTokenizer.CurrentToken = "break" Then
				Set nodStatement = New NodeBreakStatement
			Else
				Set nodStatement = New NodeStatement
			End If
			
			Call nodStatement.Parse(objTokenizer)
			
			Call pcolNodStatement.Add(nodStatement)
		Loop
		
		objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeLoopStatementBlock.Compile")
		Dim nodStatement
		For Each nodStatement In pcolNodStatement.Items
			Call nodStatement.Compile(objContext)
		Next
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeLoopStatementBlock.ToString")
		ToString = "block(loop):" & vbCrLf
		
		Dim nodStatement
		For Each nodStatement In pcolNodStatement.Items
			ToString = ToString & StringAddIndent(nodStatement.ToString())
		Next
	Call EndFunction()
	End Function
End Class

Class NodeNull
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeNull.Parse")
		If objTokenizer.CurrentToken <> "null" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[hunullv܂B(ǂݎ=" & objTokenizer.CurrentToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeNull.Compile")
		Call objContext.AddCommandLinePushValue("null", "")
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeNull.ToString")
		ToString = "null:" & vbCrLf
	Call EndFunction()
	End Function
End Class

Class NodeNumber
	Private pstrValue
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeNumber.Parse")
		pstrValue = objTokenizer.CurrentToken
		If Not IsNumberToken(pstrValue) Then
			Call Err.Raise(1, "NodeNumber", "ǂݎlł͂܂B(ǂݎ=" & pstrValue & ")")
		End If
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeNumber.Compile")
		Call objContext.AddCommandLinePushValue("number", pstrValue)
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeNumber.ToString")
		ToString = "number: " & pstrValue & vbCrLf
	Call EndFunction()
	End Function
End Class

Class NodeOperand
	Private pnodNode
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeOperand.Parse")
		Dim strToken
		strToken = objTokenizer.CurrentToken
		
		If IsNumberToken(strToken) Then
			Set pnodNode = New NodeNumber
			Call pnodNode.Parse(objTokenizer)
		ElseIf strToken = "true" Or strToken = "false" Then
			Set pnodNode = New NodeBool
			Call pnodNode.Parse(objTokenizer)
		ElseIf strToken = "null" Then
			Set pnodNode = New NodeNull
			Call pnodNode.Parse(objTokenizer)
		ElseIf strToken = """" Then
			Set pnodNode = New NodeString
			Call pnodNode.Parse(objTokenizer)
		ElseIf strToken = "native" Then
			Set pnodNode = New NodeCallNativeFunction
			Call pnodNode.Parse(objTokenizer)
		ElseIf strToken = "(" Then
			Call objTokenizer.MoveNextToken
			
			Set pnodNode = New NodeExpression
			Call pnodNode.Parse(objTokenizer)
			
			strToken = objTokenizer.CurrentToken
			If strToken <> ")" Then
				Call Err.Raise(1, "NodeOperand", "L[[hu)v܂B(ǂݎ=" & strToken & ")")
			End If
			
			Call objTokenizer.MoveNextToken
		ElseIf objTokenizer.Peek() = "(" Then
			Set pnodNode = New NodeCallFunction
			Call pnodNode.Parse(objTokenizer)
		Else
			Set pnodNode = New NodeVariable
			Call pnodNode.Parse(objTokenizer)
		End If
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeOperand.Compile")
		Call pnodNode.Compile(objContext)
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeOperand.ToString")
		ToString = pnodNode.ToString()
	Call EndFunction()
	End Function
End Class

Class NodeProgram
	Private pcolNode
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeProgram.Parse")
		Dim strToken
		Dim nodNode
		
		Call objTokenizer.MoveNextToken
		
		Set pcolNode = New Collection
		
		Do While True
			strToken = objTokenizer.CurrentToken
			If strToken = "function" Then
				Set nodNode = New NodeFunction
			ElseIf strToken = Empty Then
				Exit Do
			Else
				Set nodNode = New NodeStatement
			End If
			
			Call nodNode.Parse(objTokenizer)
			
			Call pcolNode.Add(nodNode)
		Loop
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeProgram.Compile")
		Dim objNode
		
		' TODO ֐̉sB
		' TODO O[oRpCB
		' TODO ֐RpCB
		' TODO xB
		
		' O[oRpCB
		For Each objNode In pcolNode.Items
			If TypeName(objNode) = "NodeStatement" Then
				Call objNode.Compile(objContext)
			End If
		Next
		
		If objContext.GetLastCommandLine <> "exit" Then
			Call objContext.AddCommandLinePushValue("number", "0")
			Call objContext.AddCommandLineExit()
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeProgram.ToString")
		ToString = "program:" & vbCrLf
		
		Dim nodNode
		For Each nodNode In pcolNode.Items
			ToString = ToString & StringAddIndent(nodNode.ToString())
		Next
	Call EndFunction()
	End Function
End Class

Class NodeReturnStatement
	Private pnodExpression
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeReturnStatement.Parse")
		If objTokenizer.CurrentToken <> "return" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[hureturnv܂B(ǂݎ=" & objTokenizer.CurrentToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
		
		If objTokenizer.CurrentToken <> ";" Then
			Set pnodExpression = New NodeExpression
			Call pnodExpression.Parse(objTokenizer)
			
			If objTokenizer.CurrentToken <> ";" Then
				Call Err.Raise(1, "Runtime.vbs", "L[[hu;v܂B(ǂݎ=" & objTokenizer.CurrentToken & ")")
			End If
		Else
			Set pnodExpression = Nothing
		End If
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeReturnStatement.Compile")
		If Not pnodExpression Is Nothing Then
			Call pnodExpression.Compile(objContext)
		Else
			If objContext.FunctionScope = "Local" Then
				Call objContext.AddCommandLinePushValue("null", "")
			Else
				Call objContext.AddCommandLinePushValue("number", "0")
			End If
		End If
		
		If objContext.FunctionScope = "Local" Then
			Call objContext.AddCommandLineReturn()
		Else
			Call objContext.AddCommandLineExit()
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeReturnStatement.ToString")
		ToString = "return:" & vbCrLf
		
		If Not pnodExpression Is Nothing Then
			ToString = ToString & StringAddIndent(pnodExpression.ToString())
		End If
	Call EndFunction()
	End Function
End Class

Class NodeStatement
	Private pnodStatement
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeStatement.Parse")
		Dim strToken
		strToken = objTokenizer.CurrentToken
		
		If strToken = "if" Then
			Set pnodStatement = New NodeIfStatement
			Call pnodStatement.Parse(objTokenizer)
		ElseIf strToken = "for" Then
			Set pnodStatement = New NodeForStatement
			Call pnodStatement.Parse(objTokenizer)
		ElseIf strToken = "foreach" Then
			Set pnodStatement = New NodeForEachStatement
			Call pnodStatement.Parse(objTokenizer)
		ElseIf strToken = "while" Then
			Set pnodStatement = New NodeWhileStatement
			Call pnodStatement.Parse(objTokenizer)
		ElseIf strToken = "var" Then
			Set pnodStatement = New NodeDeclareVariable
			Call pnodStatement.Parse(objTokenizer)
		ElseIf strToken = "return" Then
			Set pnodStatement = New NodeReturnStatement
			Call pnodStatement.Parse(objTokenizer)
		Else
			Set pnodStatement = New NodeExpression
			Call pnodStatement.Parse(objTokenizer)
			
			strToken = objTokenizer.CurrentToken
			If strToken <> ";" Then
				Call Err.Raise(1, "Runtime.vbs", "L[[hu;v܂B(ǂݎ=" & strToken & ")")
			End If
			
			Call objTokenizer.MoveNextToken
		End If
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeStatement.Compile")
		Call pnodStatement.Compile(objContext)
		
		If TypeName(pnodStatement) = "NodeExpression" Then
			Call objContext.AddCommandLinePop()
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeStatement.ToString")
		ToString = pnodStatement.ToString()
	Call EndFunction()
	End Function
End Class

Class NodeStatementBlock
	Private pcolNodStatement
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeStatementBlock.Parse")
		Dim strToken
		Dim nodStatement
		
		strToken = objTokenizer.CurrentToken
		If strToken <> "{" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[hu{v܂B(ǂݎ=" & strToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
		
		Set pcolNodStatement = New Collection
		
		Do While True
			strToken = objTokenizer.CurrentToken
			If strToken = "}" Then
				Exit Do
			End If
			
			Set nodStatement = New NodeStatement
			Call nodStatement.Parse(objTokenizer)
			
			Call pcolNodStatement.Add(nodStatement)
		Loop
		
		objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeStatementBlock.Compile")
		Dim nodStatement
		For Each nodStatement In pcolNodStatement.Items
			Call nodStatement.Compile(objContext)
		Next
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeStatementBlock.ToString")
		ToString = "block:" & vbCrLf
		
		Dim nodStatement
		For Each nodStatement In pcolNodStatement.Items
			ToString = ToString & StringAddIndent(nodStatement.ToString())
		Next
	Call EndFunction()
	End Function
End Class

Class NodeString
	Private pstrString
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeString.Parse")
		Dim strToken
		
		strToken = objTokenizer.CurrentToken
		If strToken <> """" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[hu""v܂B(ǂݎ=" & strToken & ")")
		End If
		
		Do While True
			strToken = objTokenizer.MoveNextTokenNotIgnore
			If strToken = """" Then
				If Len(pstrString) = 0 Then
					Exit Do
				ElseIf Mid(pstrString, Len(pstrString), 1) <> "\" Then
					Exit Do
				End If
			End If
			
			pstrString = pstrString & strToken
		Loop
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeString.Compile")
		Call objContext.AddCommandLinePushValue("string", pstrString)
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeString.ToString")
		ToString = "string: " & pstrString & vbCrLf
	Call EndFunction()
	End Function
End Class

Class NodeVariable
	Private pstrVariableName
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeVariable.Parse")
		pstrVariableName = objTokenizer.CurrentToken
		If Not IsIdentifierToken(pstrVariableName) Then
			Call Err.Raise(1, "NodeVariable", "ϐʎq̌`ł͂܂B(ǂݎ=" & pstrVariableName & ")")
		End If
		
		Call objTokenizer.MoveNextToken
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeVariable.Compile")
		Dim objVariable
		
		If Not objContext.IsDeclaredVariable(pstrVariableName) Then
			Call Err.Raise(1, "NodeVariable", "ϐu" & pstrVariableName & "v͐錾Ă܂B")
		End If
		
		Set objVariable = objContext.GetVariable(pstrVariableName)
		
		If objVariable.FunctionScope = "Global" Then
			Call objContext.AddCommandLinePushGlobalVariable(objVariable.MemoryNumber)
		Else
			Call objContext.AddCommandLinePushLocalVariable(objVariable.MemoryNumber)
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeVariable.ToString")
		ToString = "variable: " & pstrVariableName & vbCrLf
	Call EndFunction()
	End Function
End Class

Class NodeWhileStatement
	Private pnodIfExpression
	Private pnodLoopStatementBlock
	
	Public Sub Parse(objTokenizer)
	Call StartFunction("NodeWhileStatement.Parse")
		Dim strToken
		
		strToken = objTokenizer.CurrentToken
		If strToken <> "while" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[huwhilev܂B(ǂݎ=" & strToken & ")")
		End If
		
		strToken = objTokenizer.MoveNextToken
		If strToken <> "(" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[hu(v܂B(ǂݎ=" & strToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
		
		Set pnodIfExpression = New NodeExpression
		Call pnodIfExpression.Parse(objTokenizer)
		
		strToken = objTokenizer.CurrentToken
		If strToken <> ")" Then
			Call Err.Raise(1, "Runtime.vbs", "L[[hu)v܂B(ǂݎ=" & strToken & ")")
		End If
		
		Call objTokenizer.MoveNextToken
		
		Set pnodLoopStatementBlock = New NodeLoopStatementBlock
		Call pnodLoopStatementBlock.Parse(objTokenizer)
	Call EndFunction()
	End Sub
	
	Public Sub Compile(objContext)
	Call StartFunction("NodeWhileStatement.Compile")
		' TODO 
	Call EndFunction()
	End Sub
	
	Public Function ToString()
	Call StartFunction("NodeWhileStatement.ToString")
		ToString = "while:" & vbCrLf _
			& StringAddIndent(pnodIfExpression.ToString()) _
			& StringAddIndent(pnodLoopStatementBlock.ToString())
	Call EndFunction()
	End Function
End Class


















































' ********************************************************************************
' R[hs
' ********************************************************************************

Class VMContext
	Private paryMemory
	Private pintRegisterProgramCounter
	Private pintRegisterStackStartAddress
	Private pintRegisterStackTopAddress
	Private pintRegisterFrameStartAddress
	Private pintRegisterVariableLength
	Private pvarRegisterOperand1
	Private pvarRegisterOperand2
	
	Public Sub Initialize(strCode)
	Call StartFunction("VMContext.Initialize")
		Dim intCount
		
		' ReLXg̓Ԃ܂B
		ReDim paryMemory(100)                ' TODO ̑傫ݒł悤ɁB
		For intCount = 0 To UBound(paryMemory)
			paryMemory(intCount) = ""
		Next
		
		pintRegisterProgramCounter = 0
		pintRegisterStackStartAddress = 0
		pintRegisterStackTopAddress = 0
		pintRegisterFrameStartAddress = 0
		pintRegisterVariableLength = 0
		pvarRegisterOperand1 = 0
		pvarRegisterOperand2 = 0
		
		' R[h͂AɊi[܂B
		Dim aryCodeLine, aryCode
		aryCodeLine = Split(strCode, vbCrLf)
		
		For intCount = 0 To UBound(aryCodeLine)
			If InStr(aryCodeLine(intCount), "push value,") = 1 Then
				paryMemory(pintRegisterStackStartAddress) = "push value"
				paryMemory(pintRegisterStackStartAddress + 1) = Mid(aryCodeLine(intCount), InStr(aryCodeLine(intCount), ",") + 1)
				Call ValidateValue(paryMemory(pintRegisterStackStartAddress + 1))
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 2
			ElseIf InStr(aryCodeLine(intCount), "push local variable,") = 1 Then
				paryMemory(pintRegisterStackStartAddress) = "push local variable"
				paryMemory(pintRegisterStackStartAddress + 1) = Mid(aryCodeLine(intCount), InStr(aryCodeLine(intCount), ",") + 1)
				Call ValidateAddress(paryMemory(pintRegisterStackStartAddress + 1))
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 2
			ElseIf InStr(aryCodeLine(intCount), "push global variable,") = 1 Then
				paryMemory(pintRegisterStackStartAddress) = "push global variable"
				paryMemory(pintRegisterStackStartAddress + 1) = Mid(aryCodeLine(intCount), InStr(aryCodeLine(intCount), ",") + 1)
				Call ValidateAddress(paryMemory(pintRegisterStackStartAddress + 1))
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 2
			ElseIf aryCodeLine(intCount) = "pop" Then
				paryMemory(pintRegisterStackStartAddress) = "pop"
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 1
			ElseIf InStr(aryCodeLine(intCount), "pop local variable,") = 1 Then
				paryMemory(pintRegisterStackStartAddress) = "pop local variable"
				paryMemory(pintRegisterStackStartAddress + 1) = Mid(aryCodeLine(intCount), InStr(aryCodeLine(intCount), ",") + 1)
				Call ValidateAddress(paryMemory(pintRegisterStackStartAddress + 1))
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 2
			ElseIf InStr(aryCodeLine(intCount), "pop global variable,") = 1 Then
				paryMemory(pintRegisterStackStartAddress) = "pop global variable"
				paryMemory(pintRegisterStackStartAddress + 1) = Mid(aryCodeLine(intCount), InStr(aryCodeLine(intCount), ",") + 1)
				Call ValidateAddress(paryMemory(pintRegisterStackStartAddress + 1))
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 2
			ElseIf aryCodeLine(intCount) = "exit" Then
				paryMemory(pintRegisterStackStartAddress) = "exit"
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 1
			ElseIf InStr(aryCodeLine(intCount), "call native function,") = 1 Then
				aryCode = Split(aryCodeLine(intCount), ",")
				
				paryMemory(pintRegisterStackStartAddress) = "call native function"
				paryMemory(pintRegisterStackStartAddress + 1) = aryCode(1)
				paryMemory(pintRegisterStackStartAddress + 2) = aryCode(2)
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 3
			ElseIf aryCodeLine(intCount) = "add" Then
				paryMemory(pintRegisterStackStartAddress) = "add"
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 1
			ElseIf aryCodeLine(intCount) = "subtract" Then
				paryMemory(pintRegisterStackStartAddress) = "subtract"
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 1
			ElseIf aryCodeLine(intCount) = "multiple" Then
				paryMemory(pintRegisterStackStartAddress) = "multiple"
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 1
			ElseIf aryCodeLine(intCount) = "divide" Then
				paryMemory(pintRegisterStackStartAddress) = "divide"
				
				pintRegisterStackStartAddress = pintRegisterStackStartAddress + 1
			ElseIf aryCodeLine(intCount) = "" Then
				' ȂB
			Else
				Call Err.Raise(1, "VMContext", "R[h͂Ɏs܂B͂łȂR[hłB[" & aryCodeLine(intCount) & "]")
			End If
		Next
		
		pintRegisterFrameStartAddress = pintRegisterStackStartAddress
		pintRegisterVariableLength = 16                 ' TODO ݒł悤ɁB
		pintRegisterStackTopAddress = pintRegisterStackStartAddress + pintRegisterVariableLength
	Call EndFunction()
	End Sub
	
	Public Property Get IsRunning()
	Call StartFunction("VMContext.IsRunning")
		IsRunning = (pintRegisterProgramCounter <> -1)
	Call EndFunction()
	End Property
	
	Public Property Get ExitCode()
	Call StartFunction("VMContext.ExitCode")
		If pintRegisterProgramCounter <> -1 Then
			Call Err.Raise(1, "VMContext", "z}V͂܂IĂ܂")
		End If
		
		ExitCode = CInt(Mid(paryMemory(pintRegisterStackTopAddress), InStr(paryMemory(pintRegisterStackTopAddress), "|") + 1))
	Call EndFunction()
	End Property
	
	Private Sub ValidateValue(strValue)
	Call StartFunction("VMContext.ValidateValue")
		If InStr(strValue, "number|") = 1 Then
			If Not IsNumberToken(Mid(strValue, Len("number|") + 1)) Then
				Call Err.Raise(1, "VMContext", "R[h͂Ɏs܂Bnumber^̒ll`ł͂܂B[" & strValue & "]")
			End If
		ElseIf InStr(strValue, "bool|") = 1 Then
			If strValue <> "bool|true" And strValue <> "bool|false" Then
				Call Err.Raise(1, "VMContext", "R[h͂Ɏs܂Bbool^̒ltrue|falseł͂܂B[" & strValue & "]")
			End If
		ElseIf InStr(strValue, "null|") = 1 Then
			If strValue <> "null|" Then
				Call Err.Raise(1, "VMContext", "R[h͂Ɏs܂Bnull^̒lł͂܂B[" & strValue & "]")
			End If
		Else
			Call Err.Raise(1, "VMContext", "R[h͂Ɏs܂B͂łȂlłB[" & strValue & "]")
		End If
	Call EndFunction()
	End Sub
	
	Private Sub ValidateAddress(strValue)
	Call StartFunction("VMContext.ValidateAddress")
		If Not IsNumberToken(strValue) Then
			Call Err.Raise(1, "VMContext", "R[h͂Ɏs܂BAhXl`ł͂܂B")
		End If
	Call EndFunction()
	End Sub
	
	Public Sub Execute()
	Call StartFunction("VMContext.Execute")
		If pintRegisterProgramCounter = -1 Then
			Call Err.Raise(1, "VMContext", "z}V͏IĂ܂B")
		End If
		
		If paryMemory(pintRegisterProgramCounter) = "push value" Then
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
			
			paryMemory(pintRegisterStackTopAddress) = paryMemory(pintRegisterProgramCounter)
			pintRegisterStackTopAddress = pintRegisterStackTopAddress + 1
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "push local variable" Then
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
			
			paryMemory(pintRegisterStackTopAddress) = paryMemory(pintRegisterFrameStartAddress + CInt(paryMemory(pintRegisterProgramCounter)))
			pintRegisterStackTopAddress = pintRegisterStackTopAddress + 1
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "push global variable" Then
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
			
			paryMemory(pintRegisterStackTopAddress) = paryMemory(pintRegisterStackStartAddress + CInt(paryMemory(pintRegisterProgramCounter)))
			pintRegisterStackTopAddress = pintRegisterStackTopAddress + 1
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "pop" Then
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "pop local variable" Then
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			paryMemory(pintRegisterFrameStartAddress + CInt(paryMemory(pintRegisterProgramCounter))) = paryMemory(pintRegisterStackTopAddress)
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "pop global variable" Then
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			paryMemory(pintRegisterStackStartAddress + CInt(paryMemory(pintRegisterProgramCounter))) = paryMemory(pintRegisterStackTopAddress)
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "exit" Then
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			pintRegisterProgramCounter = -1
		ElseIf paryMemory(pintRegisterProgramCounter) = "call native function" Then
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
			
			If paryMemory(pintRegisterProgramCounter) = "print" And paryMemory(pintRegisterProgramCounter + 1) = "1" Then
				pintRegisterProgramCounter = pintRegisterProgramCounter + 2
				
				pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
				MsgBox paryMemory(pintRegisterStackTopAddress)
				
				pintRegisterStackTopAddress = pintRegisterStackTopAddress + 1
				paryMemory(pintRegisterStackTopAddress) = "null|"
			Else
				Call Err.Raise(1, "VMContext", "printȊȎgݍ݊֐͖łB")
			End If
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "add" Then
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			pvarRegisterOperand2 = paryMemory(pintRegisterStackTopAddress)
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			pvarRegisterOperand1 = paryMemory(pintRegisterStackTopAddress)
			
			If InStr(pvarRegisterOperand1, "number|") = 1 And InStr(pvarRegisterOperand2, "number|") = 1 Then
				paryMemory(pintRegisterStackTopAddress) = "number|" & CStr(CDbl(Mid(pvarRegisterOperand1, InStr(pvarRegisterOperand1, "|") + 1)) + CDbl(Mid(pvarRegisterOperand2, InStr(pvarRegisterOperand2, "|") + 1)))
			ElseIf (InStr(pvarRegisterOperand1, "number|") Or InStr(pvarRegisterOperand1, "string|")) And (InStr(pvarRegisterOperand2, "number|") Or InStr(pvarRegisterOperand2, "string|")) Then
				paryMemory(pintRegisterStackTopAddress) = "string|" & Mid(pvarRegisterOperand1, InStr(pvarRegisterOperand1, "|") + 1) & Mid(pvarRegisterOperand2, InStr(pvarRegisterOperand2, "|") + 1)
			Else
				Call Err.Raise(1, "VMContext", "Zł܂B[1=" & pvarRegisterOperand1 & ", 2=" & pvarRegisterOperand2 & "]")
			End If
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress + 1
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "subtract" Then
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			pvarRegisterOperand2 = paryMemory(pintRegisterStackTopAddress)
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			pvarRegisterOperand1 = paryMemory(pintRegisterStackTopAddress)
			
			If InStr(pvarRegisterOperand1, "number|") = 1 And InStr(pvarRegisterOperand2, "number|") = 1 Then
				paryMemory(pintRegisterStackTopAddress) = "number|" & CStr(CDbl(Mid(pvarRegisterOperand1, InStr(pvarRegisterOperand1, "|") + 1)) - CDbl(Mid(pvarRegisterOperand2, InStr(pvarRegisterOperand2, "|") + 1)))
			Else
				Call Err.Raise(1, "VMContext", "Zł܂B[1=" & pvarRegisterOperand1 & ", 2=" & pvarRegisterOperand2 & "]")
			End If
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress + 1
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "multiple" Then
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			pvarRegisterOperand2 = paryMemory(pintRegisterStackTopAddress)
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			pvarRegisterOperand1 = paryMemory(pintRegisterStackTopAddress)
			
			If InStr(pvarRegisterOperand1, "number|") = 1 And InStr(pvarRegisterOperand2, "number|") = 1 Then
				paryMemory(pintRegisterStackTopAddress) = "number|" & CStr(CDbl(Mid(pvarRegisterOperand1, InStr(pvarRegisterOperand1, "|") + 1)) * CDbl(Mid(pvarRegisterOperand2, InStr(pvarRegisterOperand2, "|") + 1)))
			Else
				Call Err.Raise(1, "VMContext", "Zł܂B[1=" & pvarRegisterOperand1 & ", 2=" & pvarRegisterOperand2 & "]")
			End If
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress + 1
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		ElseIf paryMemory(pintRegisterProgramCounter) = "divide" Then
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			pvarRegisterOperand2 = paryMemory(pintRegisterStackTopAddress)
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress - 1
			pvarRegisterOperand1 = paryMemory(pintRegisterStackTopAddress)
			
			If InStr(pvarRegisterOperand1, "number|") = 1 And InStr(pvarRegisterOperand2, "number|") = 1 Then
				paryMemory(pintRegisterStackTopAddress) = "number|" & CStr(CDbl(Mid(pvarRegisterOperand1, InStr(pvarRegisterOperand1, "|") + 1)) / CDbl(Mid(pvarRegisterOperand2, InStr(pvarRegisterOperand2, "|") + 1)))
			Else
				Call Err.Raise(1, "VMContext", "Zł܂B[1=" & pvarRegisterOperand1 & ", 2=" & pvarRegisterOperand2 & "]")
			End If
			
			pintRegisterStackTopAddress = pintRegisterStackTopAddress + 1
			
			pintRegisterProgramCounter = pintRegisterProgramCounter + 1
		Else
			Call Err.Raise(1, "VMContext", "FłȂR[hłB[vOEJE^=" & pintRegisterProgramCounter & ", R[h=" & paryMemory(pintRegisterProgramCounter) & "]")
		End If
	Call EndFunction()
	End Sub
	
	Public Function ToStringMemory()
	Call StartFunction("VMContext.ToStringMemory")
		Dim intCount
		
		ToStringMemory = ""
		
		For intCount = 0 To UBound(paryMemory)
			ToStringMemory = ToStringMemory & intCount & "," & paryMemory(intCount) & vbCrLf
		Next
	Call EndFunction()
	End Function
	
	Public Function ToStringRegister()
	Call StartFunction("VMContext.ToStringRegister")
		ToStringRegister = "programCounter," & pintRegisterProgramCounter & vbCrLf _
			& "stackStartAddress," & pintRegisterStackStartAddress & vbCrLf _
			& "stackTopAddress," & pintRegisterStackTopAddress & vbCrLf _
			& "frameStartAddress," & pintRegisterFrameStartAddress & vbCrLf _
			& "variableLength," & pintRegisterVariableLength & vbCrLf _
			& "operand1," & pvarRegisterOperand1 & vbCrLf _
			& "operand2," & pvarRegisterOperand2 & vbCrLf
	Call EndFunction()
	End Function
End Class















































' ********************************************************************************
' [eBeB
' ********************************************************************************

' ***** RNV *****

Class Collection
	Private pobjArray
	
	Private Sub Class_Initialize()
		ReDim pobjArray(0)
	End Sub
	
	Public Property Get Count()
		Count = UBound(pobjArray)
	End Property
	
	Public Property Get Item(intIndex)
		If intIndex < 1 Or intIndex > UBound(pobjArray) Then
			Call Err.Raise(1, "Collection", "RNV͈̔͊ÕCfbNXw肳܂B[intIndex=" & intIndex & "]")
		End If
		
		If IsObject(pobjArray(intIndex)) Then
			Set Item = pobjArray(intIndex)
		Else
			Item = pobjArray(intIndex)
		End If
	End Property
	
	Public Property Let Item(intIndex, varItem)
		If intIndex < 1 Or intIndex > UBound(pobjArray) Then
			Call Err.Raise(1, "Collection", "RNV͈̔͊ÕCfbNXw肳܂B[intIndex=" & intIndex & "]")
		End If
		
		pobjArray(intIndex) = varItem
	End Property
	
	Public Property Set Item(intIndex, varItem)
		If intIndex < 1 Or intIndex > UBound(pobjArray) Then
			Call Err.Raise(1, "Collection", "RNV͈̔͊ÕCfbNXw肳܂B[intIndex=" & intIndex & "]")
		End If
		
		Set pobjArray(intIndex) = varItem
	End Property
	
	Public Property Get Items()
		Dim intCount
		
		Dim dicItem
		Set dicItem = CreateObject("Scripting.Dictionary")
		
		For intCount = 1 To UBound(pobjArray)
			Call dicItem.Add(intCount, pobjArray(intCount))
		Next
		
		Items = dicItem.Items
	End Property
	
	Public Sub Add(varItem)
		Redim Preserve pobjArray(UBound(pobjArray) + 1)
		
		If IsObject(varItem) Then
			Set pobjArray(UBound(pobjArray)) = varItem
		Else
			pobjArray(UBound(pobjArray)) = varItem
		End If
	End Sub
	
	Public Function Remove(intIndex)
		If IsObject(Me.Item(intIndex)) Then
			Set Remove = Me.Item(intIndex)
		Else
			Remove = Me.Item(intIndex)
		End If
		
		Dim intCount
		intCount = intIndex
		
		Do While intCount < UBound(pobjArray)
			If IsObject(pobjArray(intCount + 1)) Then
				Set pobjArray(intCount) = pobjArray(intCount + 1)
			Else
				pobjArray(intCount) = pobjArray(intCount + 1)
			End If
			
			intCount = intCount + 1
		Loop
		
		ReDim Preserve pobjArray(UBound(pobjArray) - 1)
	End Function
	
	Public Function RemoveLast()
		If IsObject(Me.Item(Me.Count)) Then
			Set RemoveLast = Me.Remove(Me.Count)
		Else
			RemoveLast = Me.Remove(Me.Count)
		End If
	End Function
	
	Public Function Exist(varItem)
		Dim varItem2
		
		For Each varItem2 In Me.Items
			If varItem = varItem2 Then
				Exist = True
				Exit Function
			End If
		Next
		
		Exist = False
	End Function
End Class

' ***** t@Co *****

' t@Cǂݍ݁Aǂݍ񂾕߂܂B
'
' @param strPath ǂݍރt@C̃t@CEpXB
' @return t@Cǂݍ񂾕B
Public Function ReadFile(strPath)
	Dim fso, fsoStream
	
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set fsoStream = fso.OpenTextFile(strPath)
	
	ReadFile = fsoStream.ReadAll()
	
	Call fsoStream.Close()
End Function

' t@Cɕ݂܂B
' t@C݂Ȃꍇ̓t@C쐬At@C݂ꍇ͏㏑܂B
'
' @param strPath ރt@C̃t@CEpXB
' @param strText t@CɏޕB
Public Sub WriteFile(strPath, strText)
	Dim fso, fsoStream
	
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set fsoStream = fso.OpenTextFile(strPath, 2, True)
	
	Call fsoStream.Write(strText)
	
	Call fsoStream.Close()
End Sub

' t@Cɕ݂܂B
' t@C݂Ȃꍇ̓t@C쐬At@C݂ꍇ͒ǉ݂܂B
'
' @param strPath ރt@C̃t@CEpXB
' @param strText t@CɏޕB
Public Sub AppendFile(strPath, strText)
	Dim fso, fsoStream
	
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set fsoStream = fso.OpenTextFile(strPath, 8, True)
	
	Call fsoStream.Write(strText)
	
	Call fsoStream.Close()
End Sub

' t@C폜܂B
'
' @param strPath 폜t@C̃t@CEpXB
Public Sub DeleteFile(strPath)
	Dim fso
	
	Set fso = CreateObject("Scripting.FileSystemObject")
	If fso.FileExists(strPath) Then
		Call fso.DeleteFile(strPath)
	End If
End Sub

' ***** O *****

' OL^܂B
' OLOG_PATH萔̃pX̃t@CɒǋL܂B
' LOG_PATH萔󕶎̏ꍇAOL^܂B
'
' @param strText OɋL^镶B
Sub WriteLog(strText)
	If Len(LOG_PATH) > 0 Then
		Call AppendFile(LOG_PATH, GetNowToString() & "," & strText & vbCrLf)
	End If
End Sub

' ֐̊JnOɋL^܂B
' OSTACKTRACE_PATH萔̃pX̃t@CɒǋL܂B
' STACKTRACE_PATH萔󕶎̏ꍇAOL^܂B
'
' ̊֐͊֐ĂяoX^bNǐՂ邽߂ɌĂяo܂B
' ֐̍ŏɕK̊֐ĂяoĂB
'
' @param strFunctionName Jn֐̊֐B
Sub StartFunction(strFunctionName)
	If Len(STACKTRACE_PATH) > 0 Then
		Call AppendFile(STACKTRACE_PATH, strFunctionName & vbCrLf)
	End If
End Sub

' ֐̏IOɋL^܂B
' OSTACKTRACE_PATH萔̃pX̃t@CɒǋL܂B
' STACKTRACE_PATH萔󕶎̏ꍇAOL^܂B
'
' ̊֐͊֐ĂяoX^bNǐՂ邽߂ɌĂяo܂B
' ֐̍ŏɕK̊֐ĂяoĂB
Sub EndFunction()
	Dim strLogLines
	Dim intCount
	
	If Len(STACKTRACE_PATH) > 0 Then
		strLogLines = Split(ReadFile(STACKTRACE_PATH), vbCrLf)
		
		Call WriteFile(STACKTRACE_PATH, "")
		For intCount = 0 To UBound(strLogLines) - 2
			Call AppendFile(STACKTRACE_PATH, strLogLines(intCount) & vbCrLf)
		Next
	End If
End Sub

' ֐̊JnEĨO폜܂B
Sub ClearStacktrace()
	If Len(STACKTRACE_PATH) > 0 Then
		Call DeleteFile(STACKTRACE_PATH)
	End If
End Sub

' ***** 񑀍 *****

Public Function RegExpTest(strPattern, strText)
	Dim objRegExp
	Set objRegExp = New RegExp
	
	objRegExp.Pattern = strPattern
	
	RegExpTest = objRegExp.Test(strText)
End Function

Public Function RegExpExecute(strPattern, strText)
	Dim objRegExp
	Set objRegExp = New RegExp
	
	objRegExp.Pattern = strPattern
	
	Set RegExpExecute = objRegExp.Execute(strText)
End Function

Public Function IsNumberToken(strText)
	IsNumberToken = RegExpTest("^[0-9]+(\.[0-9]+)?$", strText)
End Function

Public Function IsIntegerToken(strText)
	IsIntegerToken = RegExpTest("^[0-9]+$", strText)
End Function

Public Function IsIdentifierToken(strText)
	If strText = "function" _
		Or strText = "if" _
		Or strText = "else" _
		Or strText = "for" _
		Or strText = "while" _
		Or strText = "foreach" _
		Or strText = "return" _
		Or strText = "break" _
		Or strText = "var" _
		Or strText = "native" _
		Or strText = "null" _
		Or strText = "true" _
		Or strText = "false" Then
		
		IsIdentifierToken = False
		Exit Function
	End If
	
	IsIdentifierToken = RegExpTest("^[a-zA-Z_][a-zA-Z0-9_]*$", strText)
End Function

Function GetNowToString()
	GetNowToString = Year(Now()) & "-" _
		& Right("00" & Month(Now()), 2) & "-" _
		& Right("00" & Day(Now()), 2) & " " _
		& Right("00" & Hour(Now()), 2) & ":" _
		& Right("00" & Minute(Now()), 2) & ":" _
		& Right("00" & Second(Now()), 2)
End Function

Public Function StringAddIndent(strText)
	Dim strLines
	strLines = Split(strText, vbCrLf)
	
	Dim strDestText
	strDestText = ""
	
	Dim intCount
	For intCount = LBound(strLines) To UBound(strLines)
		If Len(strLines(intCount)) > 0 Then
			strDestText = strDestText & " " & strLines(intCount) & vbCrLf
		End If
	Next
	
	StringAddIndent = strDestText
End Function

Class Tokenizer
	Private pstrText
	Private pcolDelimiter
	Private pcolIgnoreToken
	Private pstrCurrentToken
	
	Public Sub Initialize(strText, colDelimiter, colIgnoreToken)
	Call StartFunction("Tokenizer.Initialize")
		pstrText = strText
		Set pcolDelimiter = colDelimiter
		Set pcolIgnoreToken = colIgnoreToken
		pstrCurrentToken = Empty
	Call EndFunction()
	End Sub
	
	Public Function MoveNextToken()
	Call StartFunction("Tokenizer.MoveNextToken")
		Do While Me.MoveNextTokenNotIgnore <> Empty
			Dim blnCheckIgnoreToken
			Dim strToken
			
			blnCheckIgnoreToken = False
			
			For Each strToken In pcolIgnoreToken.Items
				If strToken = Me.CurrentToken Then
					blnCheckIgnoreToken = True
				End If
			Next
			
			If Not blnCheckIgnoreToken Then
				Exit Do
			End If
		Loop
		
		MoveNextToken = Me.CurrentToken
	Call EndFunction()
	End Function
	
	Public Function MoveNextTokenNotIgnore()
	Call StartFunction("Tokenizer.MoveNextTokenNotIgnore")
		If Len(pstrText) = 0 Then
			pstrCurrentToken = Empty
			MoveNextTokenNotIgnore = Me.CurrentToken
			Exit Function
		End If
		
		Dim intLocation
		Dim strMinDelimiter
		Dim strDelimiter
		
		intLocation = 0
		
		For Each strDelimiter In pcolDelimiter.Items
			If InStr(1, pstrText, strDelimiter) > 0 Then
				If intLocation = 0 Or intLocation > InStr(1, pstrText, strDelimiter) Then
					intLocation = InStr(1, pstrText, strDelimiter)
					strMinDelimiter = strDelimiter
				End If
			End If
		Next
		
		If intLocation = 0 Then
			pstrCurrentToken = pstrText
			pstrText = ""
		ElseIf intLocation = 1 Then
			pstrCurrentToken = Mid(pstrText, 1, Len(strMinDelimiter))
			pstrText = Mid(pstrText, Len(strMinDelimiter) + 1)
		Else
			pstrCurrentToken = Mid(pstrText, 1, intLocation - 1)
			pstrText = Mid(pstrText, intLocation)
		End If
		
		MoveNextTokenNotIgnore = Me.CurrentToken
	Call EndFunction()
	End Function
	
	Public Property Get CurrentToken()
	Call StartFunction("Tokenizer.CurrentToken")
		CurrentToken = pstrCurrentToken
	Call EndFunction()
	End Property
	
	Public Function Peek()
	Call StartFunction("Tokenizer.Peek")
		Dim strText
		Dim strCurrentToken
		
		strText = pstrText
		strCurrentToken = pstrCurrentToken
		
		Dim strToken
		strToken = Me.MoveNextToken
		
		pstrText = strText
		pstrCurrentToken = strCurrentToken
		
		Peek = strToken
	Call EndFunction()
	End Function
End Class

' ***** eXg֘A *****

Public Sub AssertEquals(var1, var2, strName)
	If var1 <> var2 Then
		Call Err.Raise(1, strName, "l1=" & var1 & ", l2=" & var2)
	End If
End Sub

Class TestContext
	Private pdicResult
	
	Private Sub Class_Initialize()
		Set pdicResult = CreateObject("Scripting.Dictionary")
	End Sub
	
	Public Sub Assert(strTestName, blnResult)
		If Not pdicResult.Exists(strTestName) Then
			pdicResult(strTestName) = blnResult
		ElseIf pdicResult(strTestName) Then
			pdicResult(strTestName) = blnResult
		End If
	End Sub
	
	Public Function ToStringResult()
		Dim strTestName
		
		ToStringResult = ""
		
		For Each strTestName In pdicResult.Keys
			If Not pdicResult(strTestName) Then
				ToStringResult = ToStringResult & strTestName & vbCrLf
			End If
		Next
	End Function
End Class















































' ********************************************************************************
' eXg
' ********************************************************************************

Public Sub TestSuite()
	Dim objContext
	
	Set objContext = New TestContext
	
	Call TestParseDeclareVariable1(objContext)
	Call TestParseDeclareVariable2(objContext)
	Call TestParseDeclareVariable3(objContext)
	Call TestCompileDeclareVariable1(objContext)
	Call TestCompileDeclareVariable2(objContext)
	Call TestCompileDeclareVariable3(objContext)
	
	If objContext.ToStringResult() = "" Then
		MsgBox "eXg͑SĐłB"
	Else
		MsgBox "seXgB" & vbCrLf & vbCrLf & objContext.ToStringResult()
	End If
End Sub

Public Sub TestParseDeclareVariable1(objContext)
	Dim strSource, strTree, strDest
	
	strSource = "var x;"
	strDest = "" _
		& "program:" & vbCrLf _
		& " declare variable:" & vbCrLf _
		& "  name: x" & vbCrLf _
	
	strTree = Parse(strSource).ToString()
	
	Call objContext.Assert("TestParseDeclareVariable1", strTree = strDest)
End Sub

Public Sub TestParseDeclareVariable2(objContext)
	Dim strSource, strTree, strDest
	
	strSource = "var x, y, z;"
	strDest = "" _
		& "program:" & vbCrLf _
		& " declare variable:" & vbCrLf _
		& "  name: x" & vbCrLf _
		& "  name: y" & vbCrLf _
		& "  name: z" & vbCrLf
	
	strTree = Parse(strSource).ToString()
	
	Call objContext.Assert("TestParseDeclareVariable1", strTree = strDest)
End Sub

Public Sub TestParseDeclareVariable3(objContext)
	Dim strSource, strTree, strDest
	
	strSource = "var x, y = 1, z = 1.41421356;"
	strDest = "" _
		& "program:" & vbCrLf _
		& " declare variable:" & vbCrLf _
		& "  name: x" & vbCrLf _
		& "  name: y" & vbCrLf _
		& "   expression(=):" & vbCrLf _
		& "    expression(==, !=):" & vbCrLf _
		& "     expression(<, <=, >, >=):" & vbCrLf _
		& "      expression(+, -):" & vbCrLf _
		& "       expression(*, /):" & vbCrLf _
		& "        number: 1" & vbCrLf _
		& "  name: z" & vbCrLf _
		& "   expression(=):" & vbCrLf _
		& "    expression(==, !=):" & vbCrLf _
		& "     expression(<, <=, >, >=):" & vbCrLf _
		& "      expression(+, -):" & vbCrLf _
		& "       expression(*, /):" & vbCrLf _
		& "        number: 1.41421356" & vbCrLf
	
	strTree = Parse(strSource).ToString()
	
	Call objContext.Assert("TestParseDeclareVariable3", strTree = strDest)
End Sub

Public Sub TestCompileDeclareVariable1(objContext)
	Dim strSource, strDest, strCode
	
	strSource = "var x;"
	strDest = "" _
		& "push value,number|0" & vbCrLf _
		& "exit" & vbCrLf
	
	strCode = Compile(Parse(strSource))
	
	Call objContext.Assert("TestCompileDeclareVariable1", strCode = strDest)
End Sub

Public Sub TestCompileDeclareVariable2(objContext)
	Dim strSource, strDest, strCode
	
	strSource = "var x, y, z;"
	strDest = "" _
		& "push value,number|0" & vbCrLf _
		& "exit" & vbCrLf
	
	strCode = Compile(Parse(strSource))
	
	Call objContext.Assert("TestCompileDeclareVariable2", strCode = strDest)
End Sub

Public Sub TestCompileDeclareVariable3(objContext)
	Dim strSource, strDest, strCode
	
	strSource = "var x, y = 1, z = 1.41421356;"
	strDest = "" _
		& "push value,number|1" & vbCrLf _
		& "pop global variable,2" & vbCrLf _
		& "push value,number|1.41421356" & vbCrLf _
		& "pop global variable,3" & vbCrLf _
		& "push value,number|0" & vbCrLf _
		& "exit" & vbCrLf
	
	strCode = Compile(Parse(strSource))
	
	Call objContext.Assert("TestCompileDeclareVariable3", strCode = strDest)
End Sub
