package tainavi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;


public class PlugIn_RecRD_MAIL_Z9500 extends HDDRecorderUtils implements HDDRecorder,Cloneable {

	public PlugIn_RecRD_MAIL_Z9500 clone() {
		return (PlugIn_RecRD_MAIL_Z9500) super.clone();
	}
	
	/* 必須コード  - ここから */
	
	// 種族の特性
	public String getRecorderId() { return "REGZA Z9500(Mail)"; }
	public RecType getType() { return RecType.MAIL; }
	
	// 個体の特性
	private ChannelCode cc = new ChannelCode(getRecorderId());
	private String rsvedFile = "";
	
	private String errmsg = "";
	
	protected String getDefFile() { return "env/mail_z9500.def"; }
	
	// 公開メソッド
	
	/*
	 * 
	 */
	public String Myself() {
		return("MAIL"+":"+getMacAddr()+":"+getRecorderId());
	}
	public ChannelCode getChCode() {
		return cc;
	}
	
	// 繰り返し予約をサポートしていない
	@Override
	public boolean isRepeatReserveSupported() { return false; }
	
	/*
	 * 
	 */
	public boolean ChangeChannel(String Channel) {
		return false;
	}

	/*
	 *	レコーダーから予約一覧を取得する 
	 */
	public boolean GetRdReserve(boolean force)
	{
		errmsg = "";
		
		System.out.println("Through: GetRdReserve("+force+")");
		
		String defFile = getDefFile();
		
		FileReader fr = null;
		BufferedReader r = null;
		try {
			encoder.clear();
			vrate.clear();
			arate.clear();
			dvdcompat.clear();
			device.clear();
			
			fr = new FileReader(defFile);
			r = new BufferedReader(fr);
			String s ;
			while ( (s = r.readLine()) != null ) {
				String[] b = s.split(",");
				if ( b.length >= 3 ) {
					TextValueSet t = new TextValueSet() ;
					t.setText(b[1]) ;
					t.setValue(b[2]) ;
					
					if ( b[0].equals("7") ) {
						encoder.add(t) ;
					}
					else if ( b[0].equals("10") ) {
						vrate.add(t) ;
					}
					else if ( b[0].equals("11") ) {
						arate.add(t) ;
					}
					else if ( b[0].equals("14") ) {
						dvdcompat.add(t) ;
					}
					else if ( b[0].equals("12") ) {
						device.add(t) ;
					}
				}
			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		finally {
			if (r != null) try { r.close(); } catch (Exception e) {};
			if (fr != null) try { fr.close(); } catch (Exception e) {};
		}
		
		// 予約一覧をキャッシュから
		rsvedFile = "env/reserved."+getIPAddr()+"_"+getPortNo()+"_"+getRecorderId()+".xml";
		
		File f = new File(rsvedFile);
		if ( force == false && f.exists()) {
			// キャッシュから読み出し（予約一覧）
			setReserves(ReservesFromFile(rsvedFile));
			if (getReserves().size() > 0) {
				System.out.println("+read from="+rsvedFile);
			}
			return(true);
		}

		return(true);
	}
	
	/*
	 *	予約を実行する
	 */
	public boolean PostRdEntry(ReserveList r)
	{
		errmsg = "";
		
		//
		if (cc.getCH_WEB2CODE(r.getCh_name()) == null) {
			errmsg = "【警告】Web番組表の放送局名「"+r.getCh_name()+"」をCHコードに変換できません。CHコード設定を修正してください。" ;
			System.out.println(errmsg);
			return(false);
		}
		
		System.out.println("Run: PostRdEntry("+r.getTitle()+")");

		// メール本文を作る
		String msg = "" ;
		String message = "";
		
		GregorianCalendar c = CommonUtils.getCalendar(r.getRec_pattern());
		if (c == null) {
			errmsg = "日付指定しか利用出来ません。" ;
			return(false) ;
		}
		msg = getMailBody(r, this.getBroadcast());
		
		try {
			message = new String(msg.getBytes("MS932"),"Shift_JIS");
		} catch (UnsupportedEncodingException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		// メールを送信する
		try {
			Properties props = new Properties() ;
			props.put("mail.smtp.host", this.getIPAddr()) ;
			props.put("mail.host", this.getIPAddr()) ;
			props.put("mail.smtp.port", this.getPortNo()) ;
			props.put("mail.smtp.auth", "true") ;
			props.put("mail.smtp.starttls.enable","true");
			
			Session session = Session.getInstance( props, new Authenticator() {
				protected PasswordAuthentication getPasswordAuthentication() {
					return new PasswordAuthentication(getUser(), getPasswd()) ;
				}
			});
			//session.setDebug(true);
			MimeMessage mimeMessage = new MimeMessage(session);
			mimeMessage.setRecipients(Message.RecipientType.TO, this.getMacAddr());
			mimeMessage.setFrom(new InternetAddress(this.getUser()));
			mimeMessage.setSubject(new Date().toString());
			mimeMessage.setSentDate(new Date());
			//mimeMessage.setText(message, "ISO-2022-JP");
			mimeMessage.setContent(message, "text/html;charset=iso-2022-jp");
			mimeMessage.setHeader("Content-Transfer-Encoding", "7bit"); 
			Transport.send(mimeMessage);
        } catch (AuthenticationFailedException e) {
        	errmsg = "SMTP認証に失敗しました："+e.toString() ;
        	return(false) ;
        } catch (MessagingException e) {
        	errmsg = "メール送信に失敗しました："+e.toString() ;
        	return(false) ;
		}
		
		// 予約ID
		long no = 0;
		for (ReserveList x : getReserves()) {
			if (Long.valueOf(x.getId()) > no) {
				no = Long.valueOf(x.getId());
			}
		}
		
		r.setId(String.valueOf(++no));
		// 予約パターンID
		r.setRec_pattern_id(getRec_pattern_Id(r.getRec_pattern()));
		
		// 次回予定日
		r.setRec_nextdate(CommonUtils.getNextDate(r));
		
		// 録画長
		r.setRec_min(CommonUtils.getRecMin(r.getAhh(),r.getAmm(),r.getZhh(),r.getZmm()));
		
		// 開始日時・終了日時
		getStartEndDateTime(r);
		
		// 予約リストを更新
		getReserves().add(r);
		
		// キャッシュに保存
		ReservesToFile(getReserves(), rsvedFile);
		
		return(true);
	}
	protected String getMailBody(ReserveList r, String passwd) {
		GregorianCalendar c = CommonUtils.getCalendar(r.getRec_pattern());
		String msg = "dtvopen ";
		msg += passwd+" ";
		msg += String.format("%04d%02d%02d ",c.get(Calendar.YEAR),c.get(Calendar.MONTH)+1,c.get(Calendar.DATE))+" ";
		msg += r.getAhh()+r.getAmm()+" ";
		msg += r.getZhh()+r.getZmm()+" ";
		msg += getChCode().getCH_WEB2CODE(r.getCh_name())+" ";
		msg += text2value(device,r.getRec_device())+" ";
		msg += text2value(dvdcompat,r.getRec_dvdcompat()); 
		msg += "\r\n";
		return msg;
	}

	/*
	 *	予約を更新する
	 */
	public boolean UpdateRdEntry(ReserveList o, ReserveList r) {
		System.out.println("Through: UpdateRdEntry()");
		
		errmsg = "更新処理は無効です。";

		return(false);
	}

	/*
	 *	予約を削除する
	 */
	public ReserveList RemoveRdEntry(String delid) {
		errmsg = "";
		
		System.out.println("Through: RemoveRdEntry()");

		// 削除対象を探す
		ReserveList rx = null;
		for (  ReserveList reserve : getReserves() )  {
			if (reserve.getId().equals(delid)) {
				rx = reserve;
				break;
			}
		}
		if (rx == null) {
			return(null);
		}
		
		// 予約リストを更新
		getReserves().remove(rx);
		
		// キャッシュに保存
		ReservesToFile(getReserves(), rsvedFile);
		
		errmsg = "鯛ナビのエントリは削除しました。REGZA上で実際のエントリを削除して下さい。";
		
		return(rx);
	}
	
	/*
	 * 
	 */
	public String getErrmsg() {
		return(errmsg.replaceAll("\\\\r\\\\n", ""));
	}
}
