﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class CActドラムキット : CActivity
	{
		protected override void Onデバイスリソースの作成()
		{
			Global.tデバイスをロックして処理を行う( ( hDevice ) => {

				this.txバス = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit Bass.png" ) );
				this.txロータム = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit LowTom.png" ) );
				this.txハイタム = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit HighTom.png" ) );
				this.txフロアタム = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit FloorTom.png" ) );
				this.txスネア = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit Snare.png" ) );
				this.txハイハット下 = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit HiHat Bottom.png" ) );
				this.txハイハット上 = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit HiHat Top.png" ) );
				this.tx右シンバルスタンド = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit RCymbal Stand.png" ) );
				this.tx右シンバル = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit RCymbal.png" ) );
				this.tx右シンバルトップ = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit RCymbal Top.png" ) );
				this.tx左シンバルスタンド = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit LCymbal Stand.png" ) );
				this.tx左シンバル = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit LCymbal.png" ) );
				this.tx左シンバルトップ = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit LCymbal Top.png" ) );

			} );
		}
		protected override void Onデバイスリソースの解放()
		{
			if( this.txバス != null )
				this.txバス.Dispose();

			if( this.txロータム != null )
				this.txロータム.Dispose();

			if( this.txハイタム != null )
				this.txハイタム.Dispose();

			if( this.txフロアタム != null )
				this.txフロアタム.Dispose();

			if( this.txスネア != null )
				this.txスネア.Dispose();

			if( this.txハイハット下 != null )
				this.txハイハット下.Dispose();

			if( this.txハイハット上 != null )
				this.txハイハット上.Dispose();

			if( this.tx右シンバルスタンド != null )
				this.tx右シンバルスタンド.Dispose();

			if( this.tx右シンバル != null )
				this.tx右シンバル.Dispose();

			if( this.tx右シンバルトップ != null )
				this.tx右シンバルトップ.Dispose();

			if( this.tx左シンバルスタンド != null )
				this.tx左シンバルスタンド.Dispose();

			if( this.tx左シンバル != null )
				this.tx左シンバル.Dispose();

			if( this.tx左シンバルトップ != null )
				this.tx左シンバルトップ.Dispose();
		}
		protected override void On描画( IntPtr hDevice )
		{
			if( this.txバス != null )
				this.txバス.t2D描画( hDevice, 881, 891 );

			if( this.txロータム != null )
				this.txロータム.t2D描画( hDevice, 999, 901 );

			if( this.txハイタム != null )
				this.txハイタム.t2D描画( hDevice, 850, 901 );

			if( this.txフロアタム != null )
				this.txフロアタム.t2D描画( hDevice, 1050, 981 );

			if( this.txスネア != null )
				this.txスネア.t2D描画( hDevice, 741, 988 );

			if( this.txハイハット下 != null )
				this.txハイハット下.t2D描画( hDevice, 657, 935 );

			if( this.txハイハット上 != null )
				this.txハイハット上.t2D描画( hDevice, 657, 935 );

			if( this.tx右シンバルスタンド != null )
				this.tx右シンバルスタンド.t2D描画( hDevice, 1229, 920 );

			if( this.tx右シンバル != null )
			{
				this.mat右シンバル = Matrix.Identity;
				this.mat右シンバル *= Matrix.Translation( 1257f - Theme.sz描画サイズ原寸px.Width / 2f, -( 923f - Theme.sz描画サイズ原寸px.Height / 2f ), 0f );
				this.tx右シンバル.t3D描画( hDevice, this.mat右シンバル );
			}

			if( this.tx右シンバルトップ != null )
				this.tx右シンバルトップ.t2D描画( hDevice, 1229, 880 );

			if( this.tx左シンバルスタンド != null )
				this.tx左シンバルスタンド.t2D描画( hDevice, 472, 916 );

			if( this.tx左シンバル != null )
			{
				this.mat左シンバル = Matrix.Identity;
				this.mat左シンバル *= Matrix.Translation( 649f - Theme.sz描画サイズ原寸px.Width / 2f, -( 918f - Theme.sz描画サイズ原寸px.Height / 2f ), 0f );
				this.tx左シンバル.t3D描画( hDevice, this.mat左シンバル );
			}

			if( this.tx左シンバルトップ != null )
				this.tx左シンバルトップ.t2D描画( hDevice, 633, 891 );
		}

		private CTexture txバス = null;
		private CTexture txロータム = null;
		private CTexture txハイタム = null;
		private CTexture txフロアタム = null;
		private CTexture txスネア = null;
		private CTexture txハイハット下 = null;
		private CTexture txハイハット上 = null;
		private CTexture tx右シンバルスタンド = null;
		private CTexture tx右シンバル = null;
		private CTexture tx右シンバルトップ = null;
		private CTexture tx左シンバルスタンド = null;
		private CTexture tx左シンバル = null;
		private CTexture tx左シンバルトップ = null;

		private Matrix mat右シンバル;	// 右シンバルは t3D描画() で描画する。
		private Matrix mat左シンバル;	// 左シンバルも t3D描画() で描画する。
	}
}
