﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	// User クラス

	class User : IDisposable
	{
		public string stg名前 = null;
		public readonly Options Options = new Options();	// ユーザ毎にオプションを持つ
		public readonly Songs Songs = new Songs();			// ユーザ毎に曲リストを持つ

		#region [ XML ]
		//-----------------
		public void Load( XmlTextReader reader )
		{
			if( reader.NodeType != XmlNodeType.Element || !reader.Name.Equals( "User" ) || reader.IsEmptyElement )
				return;

			while( reader.Read() )
			{
				if( reader.NodeType == XmlNodeType.EndElement && reader.Name.Equals("User") )
					break;

				if( reader.NodeType == XmlNodeType.Element && !reader.IsEmptyElement )
				{
					switch( reader.Name )
					{
						case "名前":
							Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
								this.stg名前 = reader.Value;
							} );
							break;

						case "Option":
							this.Options.Load( reader );
							break;

						case "Songs":
							this.Songs.Load( reader );
							break;
					}
				}
			}
		}
		public void Save( XmlTextWriter writer )
		{
			writer.WriteElementString( "名前", null, this.stg名前 );
			this.Options.Save( writer );
			this.Songs.Save( writer );
		}
		//-----------------
		#endregion

		#region [ IDisposable 実装 ]
		//-----------------
		public void Dispose()
		{
			if( this.Songs != null )
				this.Songs.Dispose();

			if( this.Options != null )
				this.Options.Dispose();
		}
		//-----------------
		#endregion
	}


	// Users クラス

	class Users : List<User>
	{
		#region [ XML ]
		//-----------------
		public void Load()
		{
			var xmlFiles = Directory.EnumerateFiles( Global.Folders.stgユーザ共通フォルダパス, @"User_*.xml" );

			foreach( var file in xmlFiles )
			{
				var xr = new XmlTextReader( new StreamReader( file ) );		// file はフルパスである

				try
				{
					while( xr.Read() )
					{
						if( xr.NodeType == XmlNodeType.EndElement && xr.Name.Equals("Users") )
							break;

						if( xr.NodeType == XmlNodeType.Element && !xr.IsEmptyElement )
						{
							switch( xr.Name )
							{
								case "User":
									var us = new User();
									us.Load( xr );
									this.Add( us );
									break;
							}
						}
					}
				}
				finally
				{
					xr.Close();
				}
			}
		}
		public void Save()
		{
			foreach( var user in this )
			{
				var xw = new XmlTextWriter( new StreamWriter( Path.Combine( Global.Folders.stgユーザ共通フォルダパス, @"User_" + user.stg名前 + @".xml" ) ) );

				try
				{
					xw.Formatting = Formatting.Indented;

					xw.WriteStartDocument();
					xw.WriteStartElement( null, "User", null );

					user.Save( xw );
		
					xw.WriteEndElement();
					xw.WriteEndDocument();
				}
				finally
				{
					xw.Close();
				}
			}
		}
		//-----------------
		#endregion

		public int SelectedUserIndex = -1;		// これを外部から修正すると
		public User SelectedUser
		{
			get
			{
				if( this.SelectedUserIndex < 0 || this.SelectedUserIndex >= this.Count )
					return null;

				return this[ this.SelectedUserIndex ];
			}
		}				// これから User を取得できる。

		public void tユーザを選択する( string stgユーザ名 )
		{
			this.SelectedUserIndex = this.FindIndex( ( user ) => { return user.stg名前.Equals( stgユーザ名 ); } );	// FindIndex() は、見つからなかったら -1 を返す。
		}

		#region [ IDisposable 実装 ]
		//-----------------
		public void Dispose()
		{
			// 内容を保存。
			this.Save();

			// ユーザオブジェクトの解放。
			foreach( var user in this )
				user.Dispose();

			// ユーザリストをクリア。
			this.Clear();
		}
		//-----------------
		#endregion
	}
}
