﻿
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;
using FDK;

namespace StrokeStyleT
{
	class Theme : IDisposable
	{
		// 固定値！ テーマのサイズを変更する場合はこれも変更すること！
		public static readonly Size sz描画サイズ原寸px = new Size( 1920, 1080 );
		public static readonly int n画面下端からヒットバー中央までの距離px = (int) ( 1080 * ( 1 - 0.88125 ) );	// 0.88125 は DTXMania のヒットバーの中心Ｙ座標の位置の割合(423÷480）
		
		public static PointF t2DXYto3DXY( Point pt2D )
		{
			return new PointF(
				pt2D.X - ( Theme.sz描画サイズ原寸px.Width / 2.0f ),
				( Theme.sz描画サイズ原寸px.Height - pt2D.Y ) - ( Theme.sz描画サイズ原寸px.Height / 2.0f ) );
		}

		public DisplayMode dm現在の表示モード { get; private set; }
		public List<DisplayMode> list現在のデスクトップフォーマットに対応する表示モードのリスト { get; private set; }

		public Theme( IntPtr hWindow )
		{
			// 現在のデスクトップフォーマット、ならびにそのフォーマットに対応する全表示モードの取得。

			this.dm現在の表示モード = Global.Direct3D.t現在のディスプレイモードを取得する();
			this.list現在のデスクトップフォーマットに対応する表示モードのリスト = Global.Direct3D.tフォーマットに対応するディスプレイモードを取得する( hWindow, this.dm現在の表示モード.Format );
		}

		#region [ IDisposable 実装 ]
		//-----------------
		public void Dispose()
		{
			this.list現在のデスクトップフォーマットに対応する表示モードのリスト.Clear();
		}
		//-----------------
		#endregion

		/// <summary>
		/// 現在の表示モードに最適なクライアントサイズを返す。
		/// （クライアントサイズの候補は Theme.cs にハードコーティングされている。）
		/// </summary>
		public Size t現在の表示モードに最適なクライアントサイズを取得する( CWindow form )
		{
			Debug.Assert( this.dm現在の表示モード.Width > 0 && this.dm現在の表示モード.Height > 0 );


			// 大きいクライアントサイズから順番にチェックしていく。

			foreach( var sz候補 in arrsz許容ウィンドウクライアントサイズ一覧 )
			{
				if( this.b現在の表示モードでウィンドウをはみ出さずに可能である( form, sz候補 ) )
					return sz候補;
			}


			// 普通なら、ここにくることはないだろうが……

			throw new Exception( "許容可能なクライアントサイズが存在しません。" );
		}


		private bool b現在の表示モードでウィンドウをはみ出さずに可能である( CWindow window, Size sz想定するクライアントサイズ )
		{
			Debug.Assert( this.dm現在の表示モード.Width > 0 && this.dm現在の表示モード.Height > 0 );

			Size sz想定されるウィンドウサイズ = window.tクライアントサイズからウィンドウサイズを計算して返す( sz想定するクライアントサイズ );
			return ( sz想定されるウィンドウサイズ.Width <= this.dm現在の表示モード.Width && sz想定されるウィンドウサイズ.Height <= this.dm現在の表示モード.Height );
		}

		private readonly Size[] arrsz許容ウィンドウクライアントサイズ一覧 = new Size[]
		{
			// 16:9 のサイズを集めてみた。大きい順に並べてある。

			new Size( 1920, 1080 ),	// SSTでの画像のピクセル原寸
			new Size( 1600, 900 ),
			new Size( 1280, 720 ),
			new Size( 1024, 576 ),
			new Size( 960, 540 ),
			new Size( 640, 360 ),
			new Size( 427, 240 ),	// これより下はないだろう。
		};
	}
}
