﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Xml;
using System.Xml.Serialization;
using FDK;

namespace StrokeStyleT
{
	// InputNote クラス - 入力データの最小単位。

	class InputNote : ICloneable
	{
		public int nデバイスID = 0;		// 入力のあったデバイスのID。
		public int nノート番号 = 0;		// 入力データ。

		#region [ XML ]
		//-----------------
		public void Load( XmlTextReader reader )
		{
			if( reader.NodeType != XmlNodeType.Element || !reader.Name.Equals( "InputNote" ) || reader.IsEmptyElement )
				return;

			string n;

			n = reader.GetAttribute( "デバイス番号" );
			this.nデバイスID = ( string.IsNullOrEmpty( n ) ) ? 0 : int.Parse( n );

			n = reader.GetAttribute( "ノート番号" );
			this.nノート番号 = ( string.IsNullOrEmpty( n ) ) ? 0 : int.Parse( n );
		}
		public void Save( XmlTextWriter writer )
		{
			// <InputNote デバイス番号="0" ノート番号="0" />	…… １行で出力。

			writer.WriteStartElement( null, "InputNote", null );
			writer.WriteAttributeString( "デバイス番号", this.nデバイスID.ToString() );
			writer.WriteAttributeString( "ノート番号", this.nノート番号.ToString() );
			writer.WriteEndElement();
		}
		//-----------------
		#endregion

		#region [ ICloneable 実装 ]
		//-----------------
		public object Clone()
		{
			return (object) new InputNote() {
				nデバイスID = this.nデバイスID,
				nノート番号 = this.nノート番号,
			};
		}
		//-----------------
		#endregion
	}


	// PadAssign クラス

	class PadAssign : IDisposable
	{
		public Dictionary<Eドラム入力, List<InputNote>> dicドラム入力to入力ノートリスト = null;

		public PadAssign()
		{
			this.dicドラム入力to入力ノートリスト = new Dictionary<Eドラム入力, List<InputNote>>();

			// 全パッド分の空のノートリストを作成。
			foreach( var pad in Enum.GetValues( typeof( Eドラム入力 ) ) )
				this.dicドラム入力to入力ノートリスト.Add( (Eドラム入力) pad, new List<InputNote>() );
		}

		#region [ XML ]
		//-----------------
		public void Load( XmlTextReader reader )
		{
			if( reader.NodeType != XmlNodeType.Element || !reader.Name.Equals( "PadAssign" ) || reader.IsEmptyElement )
				return;

			while( reader.Read() )
			{
				if( reader.NodeType == XmlNodeType.EndElement && reader.Name.Equals( "PadAssign" ) )
					break;

				if( reader.NodeType == XmlNodeType.Element && !reader.IsEmptyElement )
				{
					Eドラム入力 eパッド;
					string stgパッド;

					if( Enum.TryParse<Eドラム入力>( reader.Name, out eパッド ) )
					{
						stgパッド = reader.Name;

						while( reader.Read() )
						{
							if( reader.NodeType == XmlNodeType.EndElement && reader.Name.Equals( stgパッド ) )
								break;

							if( reader.NodeType == XmlNodeType.Element && reader.Name.Equals( "InputNote" ) && !reader.IsEmptyElement )
							{
								var note = new InputNote();
								note.Load( reader );
								Debug.Assert( this.dicドラム入力to入力ノートリスト.ContainsKey( eパッド ) );	// コンストラクタで全パッドをdicに登録済み
								this.dicドラム入力to入力ノートリスト[ eパッド ].Add( note );
							}
						}
					}
				}
			}
		}
		public void Save( XmlTextWriter writer )
		{
			writer.WriteStartElement( null, "PadAssign", null );	// <PadAssign>
			{
				foreach( var kvp in this.dicドラム入力to入力ノートリスト )
				{
					writer.WriteStartElement( null, kvp.Key.ToString(), null );
					{
						foreach( var note in kvp.Value )
							note.Save( writer );
					}
					writer.WriteEndElement();
				}
			}
			writer.WriteEndElement();								// </PadAssign>
		}
		//-----------------
		#endregion

		#region [ IDisposable 実装 ]
		//-----------------
		public void Dispose()
		{
			if( this.dicドラム入力to入力ノートリスト != null )
			{
				// パッドのノートリストをクリア。
				foreach( var kvp in this.dicドラム入力to入力ノートリスト )
					kvp.Value.Clear();

				this.dicドラム入力to入力ノートリスト.Clear();
				this.dicドラム入力to入力ノートリスト = null;
			}
		}
		//-----------------
		#endregion
	}
}
