﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class CActGUIボタン : CActGUIBase
	{
		public bool b押下中 { get; private set; }

		public CActGUIボタン( CActGUIパネル ParentPanel, string stg通常時画像ファイルパス, string stg押下時画像ファイルパス )
			: base( ParentPanel )
		{
			// 画像がちゃんと生成できて、サイズを取得するついでに２つの画像のサイズが等しいことを確認する。

			using( Bitmap bmp1 = new Bitmap( stg通常時画像ファイルパス ),
						  bmp2 = new Bitmap( stg押下時画像ファイルパス ) )
			{
				if( bmp1.Width != bmp2.Width || bmp1.Height != bmp2.Height )
					throw new Exception( "指定された２つの画像の大きさが等しくありません。" );

				this.Size = new Size( bmp1.Width, bmp1.Height );
			}

			// 確認OK。以下、初期化。

			this.b押下中 = false;

			this.stg通常時画像ファイルパス = stg通常時画像ファイルパス;
			this.stg押下時画像ファイルパス = stg押下時画像ファイルパス;
	
			this.MouseDown += ( s, e ) => { this.b押下中 = true; };
			this.MouseUp += ( s, e ) => { this.b押下中 = false; };
			this.MouseLeave += ( s, e ) => { this.b押下中 = false; };
		}

		protected string stg通常時画像ファイルパス = null;
		protected string stg押下時画像ファイルパス = null;
		protected CTexture tx通常時 = null;
		protected CTexture tx押下時 = null;

		protected override void Onデバイスリソースの作成()
		{
			Global.tデバイスをロックして処理を行う( ( hDevice ) => {
				this.tx通常時 = new CTexture( hDevice, this.stg通常時画像ファイルパス );
				this.tx押下時 = new CTexture( hDevice, this.stg押下時画像ファイルパス );
			} );

			base.Onデバイスリソースの作成();
		}
		protected override void Onデバイスリソースの解放()
		{
			if( this.tx通常時 != null )
				this.tx通常時.Dispose();

			if( this.tx押下時 != null )
				this.tx押下時.Dispose();
			
			base.Onデバイスリソースの解放();
		}
		protected override void On描画( IntPtr hDevice )
		{
			// 自分を描画。
			CActGUIBase.t親パネル相対位置で描画する( hDevice, this, ( this.b押下中 ) ? this.tx押下時 : this.tx通常時 );

			// 子Activityを持つならそれも描画。後から Add() した子ほど上に描画されることになる。
			base.On描画( hDevice );
		}
	}
}
