#include "stdafx.h"
#include "refCSerializableDictionary.h"

namespace FDK
{
	generic<typename TKey, typename TValue>
	XmlSchema^ CSerializableDictionary<TKey, TValue>::GetSchema()
	{
		return nullptr;
	}

	generic<typename TKey, typename TValue>
	void CSerializableDictionary<TKey, TValue>::ReadXml( XmlReader^ reader )
	{
		XmlSerializer^ s = gcnew XmlSerializer( KeyValue::typeid );

		reader->Read();
		while( reader->NodeType != XmlNodeType::EndElement )
		{
			KeyValue^ kv = (KeyValue^) s->Deserialize( reader );
			Add( kv->Key, kv->Value );
		}
		reader->Read();
	}

	generic<typename TKey, typename TValue>
	void CSerializableDictionary<TKey, TValue>::WriteXml( XmlWriter^ writer )
	{
		XmlSerializer^ s = gcnew XmlSerializer( KeyValue::typeid );

		for each ( TKey key in Keys )
		{
			s->Serialize( writer, gcnew KeyValue( key, this[ key ] ) );
		}
	}
}