#pragma once

namespace FDK
{
	struct CritSec
	{
	public:
		CritSec()
		{
			::InitializeCriticalSection( &m_criticalSection );
			this->bLocked = false;
		}
		~CritSec()
		{
			if( this->bLocked )
				this->Unlock();

			::DeleteCriticalSection( &m_criticalSection );
		}

		void Lock()
		{
			::EnterCriticalSection( &m_criticalSection );
			this->bLocked = true;
		}
		void Unlock()
		{
			this->bLocked = false;
			::LeaveCriticalSection( &m_criticalSection );
		}
		bool bLock()
		{
			return this->bLocked;
		}

	private:
		CRITICAL_SECTION m_criticalSection;
		bool bLocked;
	};
}
