#include "stdafx.h"
#include "valDisplayMode.h"

namespace FDK
{
	float DisplayMode::AspectRatio::get()
	{
		return static_cast<float>(this->Width) / static_cast<float>(this->Height);
	}

	bool DisplayMode::operator == ( DisplayMode left, DisplayMode right )
	{
		return DisplayMode::Equals( left, right );
	}
	bool DisplayMode::operator != ( DisplayMode left, DisplayMode right )
	{
		return !DisplayMode::Equals( left, right );	
	}
	bool DisplayMode::Equals( DisplayMode% value1, DisplayMode% value2 )
	{
		return ( value1.Width == value2.Width && value1.Height == value2.Height && value1.RefreshRate == value2.RefreshRate && value1.Format == value2.Format );
	}

	int DisplayMode::GetHashCode()
	{
		return Width.GetHashCode() + Height.GetHashCode() + RefreshRate.GetHashCode() + Format.GetHashCode();
	}
	bool DisplayMode::Equals( Object^ obj )
	{
		if( obj == nullptr )
			return false;

		if( obj->GetType() != GetType() )
			return false;

		return Equals( safe_cast<DisplayMode>( obj ) );
	}
	bool DisplayMode::Equals( DisplayMode value )
	{
		return ( Width == value.Width && Height == value.Height && RefreshRate == value.RefreshRate && Format == value.Format );
	}
}