﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK;

namespace SST.ステージ
{
	class コンソールフォント : FDK.Activity
	{
		public float 改行幅dpx => 32f;

		public float 文字幅dpx => 14f;	// 画像では文字幅は 16px だが、表示するときはちょっと狭くする。

		public コンソールフォント()
		{
			this.子リスト.Add( this._フォント白32x16 = new FDK.メディア.画像( @"$(Static)\images\コンソールフォント白16x32.png" ) );

			this._文字の矩形領域 = new SharpDX.RectangleF[ 96 ];
			for( int i = 0; i < 96; i++ )
			{
				this._文字の矩形領域[ i ] = new SharpDX.RectangleF(
					x: ( i % 16 ) * 16,
					y: ( i / 16 ) * 32,
					width: 16,
					height: 32 );
			}
		}

		public void 描画する( FDK.メディア.デバイスリソース dr, float Xdpx, float Ydpx, string 描画する文字列, float 不透明度0to1 = 1f )
		{
			if( null == this._フォント白32x16 )
				return;

			float 左端dpx = Xdpx;

			for( int i = 0; i < 描画する文字列.Length; i++ )
			{
				char ch = 描画する文字列[ i ];

				if( ch == '\n' )
				{
					// (A) 改行
					Xdpx = 左端dpx;
					Ydpx += 改行幅dpx;
				}
				else
				{
					int n = this._表記可能文字.LastIndexOf( ch );

					if( 0 <= n )
					{
						// (B) 通常文字
						this._フォント白32x16.描画する( dr, Xdpx, Ydpx, 不透明度0to1, 転送元矩形dpx: this._文字の矩形領域[ n ] );
						Xdpx += this._文字の矩形領域[ n ].Width;
					}
					else
					{
						// (C) 未対応文字 → 空白扱い
						Xdpx += 文字幅dpx;
					}
				}
			}
		}

		private FDK.メディア.画像 _フォント白32x16 = null;

		private SharpDX.RectangleF[] _文字の矩形領域 = null;     // [96]

		private readonly string _表記可能文字 = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ ";
	}
}
