﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.ServiceModel;
using System.Windows.Forms;

namespace SST
{
	static class Program
	{
		[STAThread]
		static void Main( string[] args )
		{
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault( false );

			// アプリを生成する。引数から、ビュアーモードかどうかの判定も行う。
			var app = new StrokeStyleT( args );

			if( StrokeStyleT.ビュアーモードである )
			{
				#region " (A) ビュアーモードでの起動（WCFサービスあり）"
				//----------------
				string serviceUri = "net.pipe://localhost/StrokeStyleT";
				string endPointName = "Viewer";
				string endPointUri = $"{serviceUri}/{endPointName}";

				// アプリのサービスホストを生成する。
				var serviceHost = new ServiceHost( app, new Uri( serviceUri ) );

				// 名前付きパイプにバインドしたエンドポイントをサービスホストへ追加する。
				serviceHost.AddServiceEndpoint(
					typeof( IStrokeStyleTService ),
					new NetNamedPipeBinding( NetNamedPipeSecurityMode.None ),
					endPointName );

				// サービスの受付を開始する。
				try
				{
					serviceHost.Open();
				}
				catch( AddressAlreadyInUseException )
				{
					MessageBox.Show( "同じアプリがすでに起動しています。多重起動はできません。", "SST Error", MessageBoxButtons.OK );
					return;
				}

				// アプリを実行する。
				try
				{
					app.Run();
				}
				finally
				{
					// サービスの受付を終了する。
					serviceHost.Close( new TimeSpan( 0, 0, 2 ) );	// 最大2sec待つ
				}
				//----------------
				#endregion
			}
			else
			{
				#region " (B) 通常の起動（WCFサービスなし）"
				//----------------
				// アプリを実行する。
				app.Run();
				//----------------
				#endregion
			}
		}
	}
}
