﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;

namespace FDK.同期
{
	/// <summary>
	///		ReaderWriterLock を lock 構文のようにシンプルに使うためのヘルパクラス。
	/// </summary>
	/// <remarks>
	///		Enter と Exit の正しい順序の呼び出しを保証する目的もある。
	/// </remarks>
	public class RWLockAction
	{
		public RWLockAction()
		{
			this._スレッド間同期 = new ReaderWriterLockSlim( LockRecursionPolicy.SupportsRecursion );  // 再入可能（実は推奨されない）
		}

		public RWLockAction( ReaderWriterLockSlim rwLocker )
		{
			Debug.Assert( null != rwLocker );
			this._スレッド間同期 = rwLocker;
		}

		public void ReadLock( System.Action Lock中に行う処理 )
		{
			this._スレッド間同期.EnterReadLock();
			try
			{
				Lock中に行う処理();
			}
			finally
			{
				this._スレッド間同期.ExitReadLock();
			}
		}

		public void WriteLock( System.Action Lock中に行う処理 )
		{
			this._スレッド間同期.EnterWriteLock();
			try
			{
				Lock中に行う処理();
			}
			finally
			{
				this._スレッド間同期.ExitWriteLock();
			}
		}

		public T ReadLock<T>( System.Func<T> Lock中に行う処理 )
		{
			this._スレッド間同期.EnterReadLock();
			try
			{
				return Lock中に行う処理();
			}
			finally
			{
				this._スレッド間同期.ExitReadLock();
			}
		}

		public T WriteLock<T>( System.Func<T> Lock中に行う処理 )
		{
			this._スレッド間同期.EnterWriteLock();
			try
			{
				return Lock中に行う処理();
			}
			finally
			{
				this._スレッド間同期.ExitWriteLock();
			}
		}

		private ReaderWriterLockSlim _スレッド間同期;
	}
}
