﻿using System;
using System.Collections.Generic;

namespace FDK.同期
{
	/// <summary>
	///		DXGIデバイスマネージャからD3Dデバイスを取得するためのロック機構。
	/// </summary>
	/// <remarks>
	///		MediaFoundation と Direct3D は、DXGI のロックを介して Direct3Dデバイス を共有する。
	/// </remarks>
	public class AutoD3DDeviceLock : IDisposable
	{
		public AutoD3DDeviceLock( SharpDX.MediaFoundation.DXGIDeviceManager deviceManager, out SharpDX.Direct3D11.Device d3dDevice )
		{
			this._DeviceManager = deviceManager;
			this._DeviceHandle = this._DeviceManager.OpenDeviceHandle();
			this._デバイスをロックし取得する( out d3dDevice );
		}

		public void Dispose()
		{
			this._デバイスを解放しロックを解除する();
			//Utility.Disposeする( ref this.deviceManager ); → ここで Dispose してはならない。Dispose する責任は呼び出しもとにある。
			this._DeviceManager = null; // 自分の参照だけを外す。
		}

		private SharpDX.MediaFoundation.DXGIDeviceManager _DeviceManager = null;

		private IntPtr _DeviceHandle = IntPtr.Zero;

		/// <param name="d3dDevice">
		///		利用が終わったら Dispose すること。
		///	</param>
		private void _デバイスをロックし取得する( out SharpDX.Direct3D11.Device d3dDevice )
		{
			var dev = this._DeviceManager.LockDevice(
				this._DeviceHandle,
				typeof( SharpDX.Direct3D11.Device ).GUID,
				true );   // Lockできるまでブロックする

			d3dDevice = SharpDX.Direct3D11.Device.FromPointer<SharpDX.Direct3D11.Device>( dev );
		}

		private void _デバイスを解放しロックを解除する()
		{
			if( IntPtr.Zero == this._DeviceHandle )
				return;

			this._DeviceManager.UnlockDevice( this._DeviceHandle );
			this._DeviceManager.CloseDeviceHandle( this._DeviceHandle );
			this._DeviceHandle = IntPtr.Zero;
		}
	}
}
