﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK;
using FDK.メディア;
using FDK.カウンタ;

namespace SST.ステージ.演奏
{
	/// <summary>
	///		チップの背景であり、レーンを示すフレーム画像。
	///		レーンフラッシュアニメも追加。
	/// </summary>
	class レーンフレーム : Activity
	{
		public float 高さ
		{
			get;
			set;
		} = 1080f;

		public float 幅
		{
			get
				=> this._レーンフレーム画像.サイズ.Width;
		}

		/// <summary>
		///		レーンフレーム左端から各レーンの中央位置までの相対距離。
		/// </summary>
		public static Dictionary<表示レーン種別, float> レーンto横中央相対位置;


		public レーンフレーム()
		{
			this.子リスト.Add( this._レーンフレーム画像 = new 画像( @"$(System)images\レーン.png" ) );
			this.子リスト.Add( this._フラッシュ破片 = new 画像( @"$(System)images\レーンフラッシュ.png" ) );
			this._フラッシュ破片.加算合成 = true;
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			レーンto横中央相対位置 = new Dictionary<表示レーン種別, float>() {
				{ 表示レーン種別.LeftCrash, +36f },
				{ 表示レーン種別.HiHat, +105f },
				{ 表示レーン種別.Foot, +105f },
				{ 表示レーン種別.Snare, +214f },
				{ 表示レーン種別.Tom1, +310f },
				{ 表示レーン種別.Bass, +381f },
				{ 表示レーン種別.Tom2, +448f },
				{ 表示レーン種別.Tom3, +544f },
				{ 表示レーン種別.RightCrash, +632f },
			};

			this._フラッシュ情報 = new Dictionary<表示レーン種別, (Counter, SharpDX.RectangleF)>() {
				{ 表示レーン種別.LeftCrash,  ( new Counter(), new SharpDX.RectangleF( 16f * 0, 0f, 16f, 32f ) ) },
				{ 表示レーン種別.HiHat,      ( new Counter(), new SharpDX.RectangleF( 16f * 1, 0f, 16f, 32f ) ) },
				{ 表示レーン種別.Foot,       ( new Counter(), new SharpDX.RectangleF( 16f * 2, 0f, 16f, 32f ) ) },
				{ 表示レーン種別.Snare,      ( new Counter(), new SharpDX.RectangleF( 16f * 3, 0f, 16f, 32f ) ) },
				{ 表示レーン種別.Tom1,       ( new Counter(), new SharpDX.RectangleF( 16f * 4, 0f, 16f, 32f ) ) },
				{ 表示レーン種別.Bass,       ( new Counter(), new SharpDX.RectangleF( 16f * 5, 0f, 16f, 32f ) ) },
				{ 表示レーン種別.Tom2,       ( new Counter(), new SharpDX.RectangleF( 16f * 6, 0f, 16f, 32f ) ) },
				{ 表示レーン種別.Tom3,       ( new Counter(), new SharpDX.RectangleF( 16f * 7, 0f, 16f, 32f ) ) },
				{ 表示レーン種別.RightCrash, ( new Counter(), new SharpDX.RectangleF( 16f * 8, 0f, 16f, 32f ) ) },
			};
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
		}

		public void フラッシュ開始( 表示レーン種別 laneType )
		{
			this._フラッシュ情報[ laneType ].Item1.開始する( 0, 10, 15 );
		}

		public void 進行描画する( グラフィックデバイス gd, float 左端 )
		{
			// (1) レーンフレームを描画する。
			this._レーンフレーム画像.描画する( gd, 左端, 0f );

			// (2) レーンフラッシュを描画する。
			var フラッシュ破片のサイズ = new SharpDX.Size2F( 16f, 32f );
			foreach( var kvp in this._フラッシュ情報 )
			{
				if( this._フラッシュ情報[ kvp.Key ].Item1.終了値に達していない )
				{
					float 割合 = this._フラッシュ情報[ kvp.Key ].Item1.現在値の割合;   // 0 → 1
					float 横拡大率 = 0.2f + 0.8f * 割合;  // 0.2 → 1.0
					割合 = (float) Math.Cos( 割合 * Math.PI / 2f );     // 1 → 0（加速しながら）

					for( float y = ( 演奏ステージ.ヒット判定バーの中央Y座標 - フラッシュ破片のサイズ.Height ); y > -( フラッシュ破片のサイズ.Height ); y -= フラッシュ破片のサイズ.Height )
					{
						this._フラッシュ破片.描画する(
							gd,
							演奏ステージ.レーンフレームの左端位置 + レーンフレーム.レーンto横中央相対位置[ kvp.Key ] - ( フラッシュ破片のサイズ.Width * 横拡大率 ) / 2f,
							y,
							不透明度0to1: 割合 * 0.75f,   // ちょっと暗めに。
							転送元矩形: this._フラッシュ情報[ kvp.Key ].Item2,
							X方向拡大率: 横拡大率 );
					}
				}
			}
		}


		private 画像 _レーンフレーム画像 = null;

		private 画像 _フラッシュ破片 = null;

		private Dictionary<表示レーン種別, (Counter, SharpDX.RectangleF)> _フラッシュ情報 = null;
	}
}
