﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK;
using FDK.メディア;
using SharpDX;
using SST.曲;
using SST.設定;

using FDKUtilities = FDK.FDKUtilities;

namespace SST.ステージ.選曲
{
	/// <summary>
	///		曲パネルリスト（９列３行）を表示する。
	/// </summary>
	/// <remarks>
	///		静止時の可視範囲は、左右両端の１列を除いた７列３行。
	///		左右両端の列は、静止時は画面外に位置しており、左右スクロール中にのみ画面内に一部が表示される。
	///		「カーソル」は、常に、曲パネル内のいずれか１枚の曲を選択している。
	///		カーソルは、初期状態では中央の曲を選択しており、本クラスのメソッドを使って上下左右に移動することができる。
	///		カーソルが選択している曲は強調表示（視覚効果として少し拡大して表示）される。
	/// </remarks>
	class 曲パネルビュー : FDK.Activity
	{
		public 曲パネルビュー()
		{
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this._活性化した直後である = true;

				// フォーカスノードを初期化する。
				var tree = App.ユーザ管理.選択されているユーザ.曲ツリー;
				if( null == tree.フォーカスノード )
				{
					// (A) 未選択なら、ルートノードの先頭ノードをフォーカスする。
					if( 0 < tree.ルートノード.子ノードリスト.Count )
					{
						tree.フォーカスする( gd, tree.ルートノード.子ノードリスト[ 0 ] );
					}
					else
					{
						// ルートノードに子がないないなら null のまま。
					}
				}
				else
				{
					// (B) なんらかのノードを選択中なら、それを継続して使用する（フォーカスノードをリセットしない）。
				}
			}
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
			}
		}

		public void 進行描画する( グラフィックデバイス gd )
		{
			Debug.Assert( this.活性化している );

			if( this._活性化した直後である )
			{
				this._活性化した直後である = false;
				this._横スクロール用カウンタ = new FDK.カウンタ.定間隔進行();
			}

			// 進行

			#region " 全パネルの横方向スクロール進行残があれば進行する。"
			//----------------
			this._横スクロール用カウンタ.経過時間の分だけ進行する( 1, () => {

				int オフセットの加減算速度 = 1;

				#region " カーソルが中央から遠いほど速くなるよう、オフセットの加減算速度（絶対値）を計算する。"
				//------------------
				int 距離 = Math.Abs( 4 - this._カーソル位置.X );
				if( 2 > 距離 )
					オフセットの加減算速度 = 1;
				else
					オフセットの加減算速度 = 2;
				//------------------
				#endregion

				// オフセット と カーソル位置.X を更新する。
				if( ( 4 > this._カーソル位置.X ) ||
				  ( ( 4 == this._カーソル位置.X ) && ( 0 > this._パネル全体のY軸回転オフセット ) ) )
				{
					#region " (A) パネルは、左から右へ、移動する。"
					//-----------------
					this._パネル全体のY軸回転オフセット += オフセットの加減算速度;

					// １列分移動した
					if( _パネルのY軸回転単位 <= this._パネル全体のY軸回転オフセット )
					{
						this._パネル全体のY軸回転オフセット -= _パネルのY軸回転単位;  // 0 付近に戻る
						this._カーソル位置.X++;
					}
					//-----------------
					#endregion
				}
				else if( ( 4 < this._カーソル位置.X ) ||
					   ( ( 4 == this._カーソル位置.X ) && ( 0 < this._パネル全体のY軸回転オフセット ) ) )
				{
					#region " (B) パネルは、右から左へ、移動する。"
					//-----------------
					this._パネル全体のY軸回転オフセット -= オフセットの加減算速度;

					// １列分移動した
					if( -( _パネルのY軸回転単位 ) >= this._パネル全体のY軸回転オフセット )
					{
						this._パネル全体のY軸回転オフセット += _パネルのY軸回転単位;  // 0 付近に戻る
						this._カーソル位置.X--;
					}
					//-----------------
					#endregion
				}

			} );
			//----------------
			#endregion

			// 描画

			var カーソル位置の曲ノード = (Node) null;   // null 可
			var 描画する曲ノード = App.ユーザ管理.選択されているユーザ.曲ツリー.フォーカスノード;

			if( null == 描画する曲ノード )
			{
				// todo: 曲が１つもない旨を表示する。
				return;
			}

			#region " 左上隅パネルに対応する曲ノードを検索する。"
			//-----------------
			int 現在のカーソルから左上隅までの差 = 0 - ( this._カーソル位置.X * 3 + this._カーソル位置.Y );   // 現在のカーソルの位置に、現在選択されている曲が対応するものとする。

			if( 0 < 現在のカーソルから左上隅までの差 )
			{
				// フォーカスリストを後方へたどる。
				for( int i = 0; i < 現在のカーソルから左上隅までの差; i++ )
					描画する曲ノード = 描画する曲ノード.次のノード;
			}
			else
			{
				// フォーカスリストを前方へたどる。
				for( int i = 現在のカーソルから左上隅までの差; i < 0; i++ )
					描画する曲ノード = 描画する曲ノード.前のノード;
			}
			//-----------------
			#endregion

			#region " 9×3枚の曲パネルを描画する。"
			//-----------------
			for( int i = 0; i < ( 9 * 3 ); i++ )
			{
				var パネル位置 = new Point( i / 3, i % 3 );

				if( パネル位置 == this._カーソル位置 )
				{
					// (A) カーソル位置にあるパネル --> 後で描画するので、覚えておく。
					カーソル位置の曲ノード = 描画する曲ノード;
				}
				else
				{
					// (B) カーソル位置以外のパネル --> 描画。
					this._パネルを一枚描画する( gd, 描画する曲ノード, パネル位置, これはカーソル位置のパネルである: false );
				}

				// 次のノードへ移動。
				描画する曲ノード = 描画する曲ノード?.次のノード;	// null なら null のまま。
			}
			//-----------------
			#endregion

			#region " カーソル位置のパネルを描画する。"
			//-----------------
			if( ( 0 <= this._カーソル位置.X ) && ( 9 > this._カーソル位置.X ) &&
				( 0 <= this._カーソル位置.Y ) && ( 3 > this._カーソル位置.Y ) )
			{
				this._パネルを一枚描画する(
					gd,
					カーソル位置の曲ノード,   // 先の for ループ内で取得済み。
					this._カーソル位置,
					これはカーソル位置のパネルである: true );
			}
			//-----------------
			#endregion
		}

		public void カーソルを上に移動する()
		{
			if( 0 < this._カーソル位置.Y )
			{
				this._カーソル位置.Y--;
			}
			else
			{
				this._カーソル位置.X--;
				this._カーソル位置.Y = 2;
			}

			// カーソルと一緒に、選択曲も移動する。
			App.ユーザ管理.選択されているユーザ.曲ツリー.前のノードをフォーカスする();
		}

		public void カーソルを下に移動する()
		{
			if( 2 > this._カーソル位置.Y )
			{
				this._カーソル位置.Y++;
			}
			else
			{
				this._カーソル位置.X++;
				this._カーソル位置.Y = 0;
			}

			// カーソルと一緒に、選択曲も移動する。
			App.ユーザ管理.選択されているユーザ.曲ツリー.次のノードをフォーカスする();
		}

		public void カーソルを左に移動する()
		{
			this._カーソル位置.X--;    // 制限なし

			// カーソルと一緒に、選択曲も移動する。
			App.ユーザ管理.選択されているユーザ.曲ツリー.前のノードをフォーカスする();  // １つ左へ ＝ ３つ前へ
			App.ユーザ管理.選択されているユーザ.曲ツリー.前のノードをフォーカスする();
			App.ユーザ管理.選択されているユーザ.曲ツリー.前のノードをフォーカスする();
		}

		public void カーソルを右に移動する()
		{
			this._カーソル位置.X++;    // 制限なし

			// カーソルと一緒に、選択曲も移動する。
			App.ユーザ管理.選択されているユーザ.曲ツリー.次のノードをフォーカスする();  // １つ右へ ＝ ３つ次へ
			App.ユーザ管理.選択されているユーザ.曲ツリー.次のノードをフォーカスする();
			App.ユーザ管理.選択されているユーザ.曲ツリー.次のノードをフォーカスする();
		}


		private const float _カーソル位置のパネルの拡大率 = 1.25f;

		private bool _活性化した直後である = false;

		private FDK.カウンタ.定間隔進行 _横スクロール用カウンタ = null;

		/// <summary>
		///		左上隅のパネルを (0,0) とした時の、カーソル位置の座標。
		///		負数も可。
		/// </summary>
		private Point _カーソル位置 = new Point( 4, 1 );
		
		/// <summary>
		///		-63～63。パネル全体の表示位置を、負数は 左 へ、正数は 右 へずらす 。（正負と左右の対応に注意。）
		/// </summary>
		private int _パネル全体のY軸回転オフセット = 0;

		/// <summary>
		///		パネル１列分のY軸回転角度を表す定数。
		///		パネルの1列分のアニメーションは、この値で分割される。
		/// </summary>
		private const int _パネルのY軸回転単位 = 100;


		/// <summary>
		///		パネルを一枚（ノード画像とタイトル画像）を、指定したパネル位置に描画する。
		/// </summary>
		private void _パネルを一枚描画する( グラフィックデバイス gd, Node パネルノード, Point パネル位置, bool これはカーソル位置のパネルである = false )
		{
			// 画面を見ながら直観的に調整した固定パラメータたち。
			const float 見かけの倍率 = 3.0f;
			const float パネル全体のY方向移動量 = +250f;    // パネル全体を少しだけ上にシフトする。
			const float パネル全体のZ方向移動量 = +3000f;
			const float 行間 = 1.1f;
			const float パネル間X方向角度deg = 19f;
			const float カーソルパネルの拡大率 = 1.5f;

			var Y軸回転 = Matrix.RotationY( MathUtil.DegreesToRadians( ( ( パネル位置.X - 4 ) + ( this._パネル全体のY軸回転オフセット / (float) ( _パネルのY軸回転単位 ) ) ) * パネル間X方向角度deg ) );

			var 拡大縮小 =
				Matrix.Scaling( Node.全体サイズ.Width, Node.全体サイズ.Height, 1f )
				* Matrix.Scaling( 見かけの倍率 )
				* ( ( これはカーソル位置のパネルである ) ? Matrix.Scaling( カーソルパネルの拡大率 ) : Matrix.Identity );

			var 平行移動 = Matrix.Translation(
				x: 0f,
				y: パネル全体のY方向移動量 + ( 1 - パネル位置.Y ) * ( Node.全体サイズ.Height * 見かけの倍率 * 行間 ),
				z: パネル全体のZ方向移動量 + ( ( これはカーソル位置のパネルである ) ? 10f : 0f ) );   // カーソルパネルは、他のパネルより上にくるように、ほんのり前に描画する。

			パネルノード.描画する( gd, ( 拡大縮小 * 平行移動 * Y軸回転 ) );
		}
	}
}
