﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace SST.Viewer
{
	/// <summary>
	///		SSTEditor から StrokeStyleT（ビュアーモード）への指示。
	/// </summary>
	class ViewerMessage
	{
		public enum 指示種別
		{
			指示なし,
			演奏開始,
			演奏停止,
		}

		public 指示種別 種別
		{
			get;
			set;
		} = 指示種別.指示なし;

		public string 演奏対象曲のファイルパス
		{
			get;
			set;
		} = null;

		public int 演奏を開始する小節番号
		{
			get;
			set;
		} = 0;

		public bool ドラムチップのヒット時に発声する
		{
			get;
			set;
		} = true;

		public override string ToString()
		{
			// デバッグ用。
			return "ViewerMessage: "
				+ $"種別={this.種別}"
				+ $", 演奏開始小節番号={this.演奏を開始する小節番号}"
				+ $", ドラムチップ発声={this.ドラムチップのヒット時に発声する}"
				+ $", 曲ファイルパス=[{SST.IO.Folder.絶対パスをフォルダ変数付き絶対パスに変換して返す( this.演奏対象曲のファイルパス )}]";
		}
	}
}
