﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using SharpDX.Direct2D1;

namespace FDK.メディア
{
	/// <summary>
	///		画像ファイルから生成され、レンダーターゲットとしても描画可能なビットマップを扱うクラス。
	/// </summary>
	public class 描画可能画像 : 画像
	{
		public 描画可能画像( string 画像ファイルパス )
			: base( 画像ファイルパス )
		{
		}

		protected override void Onデバイス依存リソースの作成( デバイスリソース dr )
		{
			this.画像を生成する(
				dr,
				new BitmapProperties1() {
					BitmapOptions = BitmapOptions.Target
				} );
		}

		/// <summary>
		///		生成済み画像（ビットマップ）に対するユーザアクションによる描画を行う。
		/// </summary>
		/// <remarks>
		///		活性化状態であれば、進行描画() 中でなくても、任意のタイミングで呼び出して良い。
		///		ユーザアクション内では BeginDraw(), EndDraw() の呼び出しは（呼び出しもとでやるので）不要。
		/// </remarks>
		/// <param name="dr">デバイスリソース。</param>
		/// <param name="描画アクション">Bitmap に対して行いたい操作。</param>
		public void 画像へ描画する( デバイスリソース dr, Action<DeviceContext1, Bitmap1> 描画アクション )
		{
			using( var 旧ターゲット = dr.D2DContext1.Target )
			{
				try
				{
					dr.D2DContextの設定をリセットする( dr.D2DContext1 );
					dr.D2DContext1.Target = this.Bitmap;
					Utilities.D2DBatchDraw( dr.D2DContext1, () => {
						描画アクション( dr.D2DContext1, this.Bitmap );
					} );
				}
				finally
				{
					dr.D2DContext1.Target = 旧ターゲット;
				}
			}
		}
	}
}
