// TreeItem.h : CTreeItem ̐錾

#ifndef __TREEITEM_H_
#define __TREEITEM_H_

#include "resource.h"       // C V{
#include "generic.h"

/////////////////////////////////////////////////////////////////////////////
// CTreeItem
class ATL_NO_VTABLE CTreeItem : 
	public CComObjectRootEx<CComSingleThreadModel>,
//	public CComCoClass<CTreeItem, &CLSID_TreeItem>,
	public ISupportErrorInfo,
	public IDispatchImpl<ITreeItem, &IID_ITreeItem, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CTreeItem()
	{
		m_hWnd = NULL;
		m_hItem = NULL;
	}
static BOOL DeleteTreeItemWithData(HWND hWnd,HTREEITEM hItem);
//DECLARE_REGISTRY_RESOURCEID(IDR_TREEITEM)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CTreeItem)
	COM_INTERFACE_ENTRY(ITreeItem)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// ITreeItem
public:
	STDMETHOD(IsValid)(/*[out,retval]*/BOOL* pResult);
	static void CreateTreeItem(HWND hWnd,HTREEITEM hParent,LPCSTR text,IUnknown** punkVal);
	STDMETHOD(Sort)()
	{
		HRESULT ret = InitialCheck();
		if(ret == S_OK){
			if(m_hItem){
				TreeView_SortChildren(m_hWnd,m_hItem,0);
			}
			else{
				// sȃACeQƂĂ
				ret = DISP_E_EXCEPTION;
			}
		}
		return ret;
	}
	STDMETHOD(Expand)()
	{
		HRESULT ret = InitialCheck();
		if(ret == S_OK){
			if(m_hItem){
				TreeView_Expand(m_hWnd,m_hItem,TVE_EXPAND);
			}
			else{
				// sȃACeQƂĂ
				ret = DISP_E_EXCEPTION;
			}
		}
		return ret;
	}
	STDMETHOD(Select)()
	{
		HRESULT ret = InitialCheck();
		if(ret == S_OK){
			if(m_hItem){
				TreeView_SelectItem(m_hWnd,m_hItem);
			}
			else{
				// sȃACeQƂĂ
				ret = DISP_E_EXCEPTION;
			}
		}
		return ret;
	}
	STDMETHOD(Erase)()
	{
		HRESULT ret = InitialCheck();
		if(ret == S_OK){
			if(m_hItem){
				if(DeleteTreeItemWithData(m_hWnd,m_hItem)){
					// 폜ɐÃnh𖳌ɂ
					m_hWnd = NULL;
					m_hItem = NULL;
				}
			}
			else{
				// sȃACeQƂĂ
				ret = DISP_E_EXCEPTION;
			}
		}
		return ret;
	}
	STDMETHOD(Create)(/*[in]*/VARIANT text,/*[out,retval]*/IUnknown** punkVal)
	{
		// ACe̍쐬
		*punkVal = NULL;
		HRESULT ret = InitialCheck();
		if(ret == S_OK){
			if(m_hItem){
				CHAR mes[MAX_PATH];
				CComVariant str;
				if(str.ChangeType(VT_BSTR,&text) == S_OK){
					int cnt = WideCharToMultiByte(GetACP(),0,str.bstrVal,-1,mes,MAX_PATH,NULL,NULL);
					CreateTreeItem(m_hWnd,m_hItem,mes,punkVal);
				}
			}
			else{
				// sȃACeQƂĂ
				ret = DISP_E_EXCEPTION;
			}
		}
		return ret;
	}
	STDMETHOD(get_Object)(/*[in,optional]*/VARIANT idx, /*[out, retval]*/ VARIANT *pVal)
	{
		// ACeɊ֘AtꂽAzzIuWFNg擾
		::VariantInit(pVal);
		HRESULT ret = InitialCheck();
		if(!m_hItem){
			ret = DISP_E_EXCEPTION;
		}
		if(ret == S_OK){
			TVITEM itm = {0};
			itm.mask   = TVIF_PARAM;
			itm.hItem  = m_hItem;
			if(TreeView_GetItem(m_hWnd,&itm)){
				IUnknown* pUnk = (IUnknown*)itm.lParam;
				if(pUnk){
					pUnk->AddRef();
					pVal->vt      = VT_UNKNOWN;
					pVal->punkVal = pUnk;
				}
			}
		}
		return ret;
	}
	HRESULT InitialCheck()
	{
		// EBhEL
		if(m_hWnd && ::IsWindow(m_hWnd)){
			return S_OK;
		}
		ErrorInfo(IDS_ERR_TREEERROR);
		return DISP_E_EXCEPTION;
	}
	STDMETHOD(get_Text)(/*[out, retval]*/ BSTR *pVal)
	{
		// eLXg̎擾
		HRESULT ret = InitialCheck();
		if(!m_hItem){
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
		if(ret == S_OK){
			CHAR text[MAX_PATH];
			TVITEM itm = {0};
			itm.mask       = TVIF_TEXT;
			itm.hItem      = m_hItem;
			itm.pszText    = text;
			itm.cchTextMax = MAX_PATH;
			if(TreeView_GetItem(m_hWnd,&itm)){
				WCHAR wMes[MAX_PATH] = {0};
				MultiByteToWideChar(GetACP(),0,text,-1,wMes,MAX_PATH);
				*pVal = SysAllocString(wMes);
			}
		}
		return ret;
	}
	STDMETHOD(put_Text)(/*[in]*/ BSTR newVal)
	{
		// eLXg̏
		HRESULT ret = InitialCheck();
		if(!m_hItem){
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
		if(ret == S_OK){
			CHAR text[MAX_PATH] = {0};
			TVITEM itm = {0};
			itm.mask       = TVIF_TEXT;
			itm.hItem      = m_hItem;
			itm.pszText    = text;
			itm.cchTextMax = MAX_PATH;
			WideCharToMultiByte(GetACP(),0,newVal,-1,text,MAX_PATH,NULL,NULL);
			TreeView_SetItem(m_hWnd,&itm);
		}
		return ret;
	}
	STDMETHOD(get_PrevItem)(/*[out, retval]*/ IUnknown* *pVal)
	{
		// ÕACe
		*pVal = NULL;
		HRESULT ret = InitialCheck();
		if(!m_hItem){
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
		if(ret == S_OK){
			HTREEITEM hNewItem = TreeView_GetPrevSibling(m_hWnd,m_hItem);
			CComObject<CTreeItem>* pItem = NULL;
			if(pItem->CreateInstance(&pItem) == S_OK){
				pItem->SetParam(m_hWnd,hNewItem);
				ret = pItem->QueryInterface(IID_IUnknown,(void**)pVal);
			}
		}
		return ret;
	}
	STDMETHOD(get_NextItem)(/*[out, retval]*/ IUnknown* *pVal)
	{
		// ̃ACe
		*pVal = NULL;
		HRESULT ret = InitialCheck();
		if(!m_hItem){
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
		if(ret == S_OK){
			HTREEITEM hNewItem = TreeView_GetNextSibling(m_hWnd,m_hItem);
			CComObject<CTreeItem>* pItem = NULL;
			if(pItem->CreateInstance(&pItem) == S_OK){
				pItem->SetParam(m_hWnd,hNewItem);
				ret = pItem->QueryInterface(IID_IUnknown,(void**)pVal);
			}
		}
		return ret;
	}
	STDMETHOD(get_ChildItem)(/*[out, retval]*/ IUnknown* *pVal)
	{
		// qACe
		*pVal = NULL;
		HRESULT ret = InitialCheck();
		if(!m_hItem){
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
		if(ret == S_OK){
			HTREEITEM hNewItem = TreeView_GetChild(m_hWnd,m_hItem);
			CComObject<CTreeItem>* pItem = NULL;
			if(pItem->CreateInstance(&pItem) == S_OK){
				pItem->SetParam(m_hWnd,hNewItem);
				ret = pItem->QueryInterface(IID_IUnknown,(void**)pVal);
			}
		}
		return S_OK;
	}
	STDMETHOD(get_Parent)(/*[out, retval]*/ IUnknown* *pVal)
	{
		// eACe
		*pVal = NULL;
		HRESULT ret = InitialCheck();
		if(!m_hItem){
			// sȃACeQƂĂ
			ret = DISP_E_EXCEPTION;
		}
		if(ret == S_OK){
			HTREEITEM hNewItem = TreeView_GetParent(m_hWnd,m_hItem);
			CComObject<CTreeItem>* pItem = NULL;
			if(pItem->CreateInstance(&pItem) == S_OK){
				pItem->SetParam(m_hWnd,hNewItem);
				ret = pItem->QueryInterface(IID_IUnknown,(void**)pVal);
			}
		}
		return S_OK;
	}
	//
	void SetParam(HWND hWnd,HTREEITEM hItem)
	{
		m_hWnd = hWnd;
		m_hItem = hItem;
	}
protected:
	HWND m_hWnd;
	HTREEITEM m_hItem;
};

#endif //__TREEITEM_H_
