// ProfileSection.cpp : CProfileSection ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "ProfileSection.h"

/////////////////////////////////////////////////////////////////////////////
// CProfileSection

STDMETHODIMP CProfileSection::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_ISeraphyScriptTools_ProfileSection
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (IsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CProfileSection::get_Value(VARIANT idx, VARIANT *pVal)
{
	::VariantInit(pVal);
	CComVariant varIdx;
	CHAR szKeyname[MAX_PATH] = { 0 };
	const int siz = 1024 * 8; // 8KBytes
	LPSTR szReturn = new CHAR[siz];
	if(varIdx.ChangeType(VT_BSTR,&idx) == S_OK){
		WideCharToMultiByte(GetACP(),0,varIdx.bstrVal,-1,szKeyname,MAX_PATH,NULL,NULL);
	}
	if(GetPrivateProfileString(m_szSectionName,szKeyname,"",szReturn,siz,m_szProfilePath)){
		CComVariant ret((LPCSTR)szReturn);
		ret.Detach(pVal);
	}
	delete[]szReturn;
	return S_OK;
}

STDMETHODIMP CProfileSection::put_Value(VARIANT idx, VARIANT newVal)
{
	// fBtHg̒l擾
	CComVariant varIdx,varNew;
	CHAR szKeyname[MAX_PATH] = { 0 };
	const int siz = 1024 * 8; // 8KBytes
	LPSTR szWrite = new CHAR[siz+1];
	if(varIdx.ChangeType(VT_BSTR,&idx) == S_OK){
		WideCharToMultiByte(GetACP(),0,varIdx.bstrVal,-1,szKeyname,MAX_PATH,NULL,NULL);
	}
	if(varNew.ChangeType(VT_BSTR,&newVal) == S_OK){
		int cnt = WideCharToMultiByte(GetACP(),0,varNew.bstrVal,-1,szWrite,siz,NULL,NULL);
		szWrite[cnt] = 0;
	}
	WritePrivateProfileString(m_szSectionName,szKeyname,szWrite,m_szProfilePath);
	delete[]szWrite;
	return S_OK;
}

STDMETHODIMP CProfileSection::GetValue(VARIANT idx, VARIANT def,VARIANT* pVal)
{
	// fBtHg̒l擾
	::VariantInit(pVal);
	CComVariant varIdx,varDef;
	CHAR szKeyname[MAX_PATH] = { 0 };
	CHAR szDefault[MAX_PATH] = { 0 };
	const int siz = 1024 * 8; // 8KBytes
	LPSTR szReturn = new CHAR[siz];
	if(varIdx.ChangeType(VT_BSTR,&idx) == S_OK){
		WideCharToMultiByte(GetACP(),0,varIdx.bstrVal,-1,szKeyname,MAX_PATH,NULL,NULL);
	}
	if(varDef.ChangeType(VT_BSTR,&def) == S_OK){
		WideCharToMultiByte(GetACP(),0,varDef.bstrVal,-1,szDefault,MAX_PATH,NULL,NULL);
	}
	if(GetPrivateProfileString(m_szSectionName,szKeyname,szDefault,szReturn,siz,m_szProfilePath)){
		CComVariant ret((LPCSTR)szReturn);
		ret.Detach(pVal);
	}
	delete[]szReturn;
	return S_OK;
}

STDMETHODIMP CProfileSection::GetKeyNames(VARIANT *pVal)
{
	// L[̗񋓂s
	DWORD siz = 4096;
	DWORD oldsiz = 0;
	DWORD retsiz = 0;
	LPSTR pBuf = new CHAR[siz];
	while(  (retsiz  = GetPrivateProfileSection(m_szSectionName,pBuf,siz,m_szProfilePath)) &&
			(retsiz == (siz - 2)) && ( oldsiz != retsiz ) ){
		oldsiz = siz;
		siz *= 2;
		delete []pBuf;
		pBuf = new CHAR[siz];
	}
	// JEg
	LPSTR p = pBuf;
	long count = 0;
	while(*p){
		count++;
		while(*p++);
	}
	// ꎟz̐
	SAFEARRAY* pArray = SafeArrayCreateVector(VT_VARIANT,0,count);
	long idx = 0;
	p = pBuf;
	while(*p){
		CComVariant tmp;
		LPCSTR pb = p;
		while(*p){
			if(*p == '='){
				*p = 0;
			}
			p++;
		}
		p++;
		tmp = (LPCSTR)pb;
		SafeArrayPutElement(pArray,&idx,&tmp);
		tmp.Clear();
		idx++;
	}
	delete[]pBuf;
	// ߂l
	::VariantInit(pVal);
	pVal->vt     = VT_VARIANT | VT_ARRAY;
	pVal->parray = pArray;
	return S_OK;
}
