// PrivateProfile.cpp : CPrivateProfile ̃Cve[V
#include "stdafx.h"
#include "SeraphyScriptTools.h"
#include "PrivateProfile.h"
#include "profilesection.h"
#include "generic.h"

/////////////////////////////////////////////////////////////////////////////
// CPrivateProfile

STDMETHODIMP CPrivateProfile::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IPrivateProfile
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (IsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CPrivateProfile::get_ProfilePath(BSTR *pVal)
{
	*pVal = m_bstr_profilepath.copy();
	return S_OK;
}

STDMETHODIMP CPrivateProfile::put_ProfilePath(BSTR newVal)
{
	m_bstr_profilepath = newVal;
	return S_OK;
}

STDMETHODIMP CPrivateProfile::OpenSection(VARIANT text,VARIANT* pVal)
{
	::VariantInit(pVal);
	CComVariant varText;
	if(varText.ChangeType(VT_BSTR,&text) != S_OK){
		return DISP_E_TYPEMISMATCH;
	}
	if(m_bstr_profilepath.length() <= 0){
		ErrorInfo(IDS_ERR_PROFILEPATH);
		return DISP_E_EXCEPTION;
	}
	CComObject<CProfileSection>* pSection = NULL;
	pSection->CreateInstance(&pSection);
	ATLASSERT(pSection);
	WideCharToMultiByte(GetACP(),0,m_bstr_profilepath,-1,pSection->m_szProfilePath,MAX_PATH,NULL,NULL);
	WideCharToMultiByte(GetACP(),0,varText.bstrVal   ,-1,pSection->m_szSectionName,MAX_PATH,NULL,NULL);
	IUnknown* pUnk = NULL;
	pSection->QueryInterface(IID_IUnknown,(void**)&pUnk);
	ATLASSERT(pUnk);
	pVal->vt      = VT_UNKNOWN;
	pVal->punkVal = pUnk;
	return S_OK;
}
